package com.atlassian.crowd.event.user;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.model.user.ImmutableUser;
import com.atlassian.crowd.model.user.User;

/**
 * User was automatically updated.
 *
 * Triggered when a user was automatically updated internally on a delegated authentication
 * directory, either after successful LDAP authentication or when specifically requested on the
 * directory itself.
 */
public class AutoUserUpdatedEvent extends UserUpdatedEvent {
    private final ImmutableUser originalUser;

    public AutoUserUpdatedEvent(Object source, Directory directory, User user, User originalUser) {
        super(source, directory, user);
        this.originalUser = new ImmutableUser(originalUser);
    }

    public User getOriginalUser() {
        return originalUser;
    }
}
