package com.atlassian.crowd.event.recovery;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.model.directory.ImmutableDirectory;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Raised when recovery mode in Crowd has been activated, usually at, or close to the initialization time of
 * the application.
 *
 * @since 2.7.2
 */
public class RecoveryModeActivatedEvent {
    private final String recoveryUsername;
    private final ImmutableDirectory recoveryDirectory;

    public RecoveryModeActivatedEvent(String recoveryUsername, Directory recoveryDirectory) {
        this.recoveryUsername = checkNotNull(recoveryUsername, "recoveryUsername");
        this.recoveryDirectory = ImmutableDirectory.builder(recoveryDirectory).build();
    }

    /**
     * @return name of the built-in user created for the purpose of recovery.
     */
    public String getUsername() {
        return recoveryUsername;
    }

    /**
     * @return the directory created for the purpose of recovery.
     */
    public Directory getDirectory() {
        return recoveryDirectory;
    }

    @Override
    public String toString() {
        return "RecoveryModeActivatedEvent{recoveryUsername='" + recoveryUsername + "'}";
    }
}
