package com.atlassian.crowd.event.group;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.event.DirectoryEvent;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.ImmutableGroup;

/**
 * An Event that represents the updating of a {@link com.atlassian.crowd.model.group.Group}
 */
public class GroupUpdatedEvent extends DirectoryEvent {
    private final ImmutableGroup group;

    public GroupUpdatedEvent(Object source, Directory directory, Group group) {
        super(source, directory);
        this.group = ImmutableGroup.builder(group).build();
    }

    public Group getGroup() {
        return group;
    }
}
