package com.atlassian.crowd.event.directory;

import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.event.Event;

/**
 * Superclass for events thrown when a directory synchronisation finishes.
 */
public abstract class RemoteDirectorySynchronisationFinishedEvent extends Event {
    private final RemoteDirectory remoteDirectory;
    private final long timeTakenInMs;

    public RemoteDirectorySynchronisationFinishedEvent(
            Object source,
            RemoteDirectory remoteDirectory,
            long timeTakenInMs) {
        super(source);
        this.remoteDirectory = remoteDirectory;
        this.timeTakenInMs = timeTakenInMs;
    }

    public RemoteDirectory getRemoteDirectory() {
        return remoteDirectory;
    }

    // accessor for Analytics
    public long getDirectoryId() {
        return remoteDirectory.getDirectoryId();
    }

    public long getTimeTakenInMs() {
        return timeTakenInMs;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o.getClass().equals(getClass()))) {
            return false;
        }

        RemoteDirectorySynchronisationFinishedEvent that = (RemoteDirectorySynchronisationFinishedEvent) o;

        if (!remoteDirectory.equals(that.remoteDirectory)) {
            return false;
        }

        return true;
    }

    @Override
    public int hashCode() {
        return remoteDirectory.hashCode();
    }
}
