package com.atlassian.crowd.event.application;

import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ImmutableApplication;

/**
 * Occurs when the configuration of an application changes.
 *
 * @see ApplicationDirectoryAddedEvent
 * @see ApplicationDirectoryRemovedEvent
 * @see ApplicationDirectoryOrderUpdatedEvent
 * @see ApplicationRemoteAddressAddedEvent
 * @see ApplicationRemoteAddressRemovedEvent
 * @since v2.6.2
 */
public class ApplicationUpdatedEvent {
    private final ImmutableApplication application;

    public ApplicationUpdatedEvent(Application application) {
        this.application = ImmutableApplication.builder(application).build();
    }

    public Application getApplication() {
        return application;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ApplicationUpdatedEvent that = (ApplicationUpdatedEvent) o;

        return application.equals(that.application);
    }

    @Override
    public int hashCode() {
        return application.hashCode();
    }

    // accessor for Analytics
    public Long getApplicationId() {
        return application.getId();
    }
}
