package com.atlassian.crowd.event.application;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ImmutableApplication;
import com.atlassian.crowd.model.directory.ImmutableDirectory;

/**
 * Event which occurs when a directory is removed from an Application's list of
 * included directories.
 */
public class ApplicationDirectoryRemovedEvent {
    private final ImmutableApplication application;
    private final ImmutableDirectory directory;

    public ApplicationDirectoryRemovedEvent(final Application application, final Directory directory) {
        this.application = ImmutableApplication.builder(application).build();
        this.directory = ImmutableDirectory.builder(directory).build();
    }

    public Application getApplication() {
        return application;
    }

    public Directory getDirectory() {
        return directory;
    }

    // accessor for Analytics
    public Long getApplicationId() {
        return application.getId();
    }

    // accessor for Analytics
    public Long getDirectoryId() {
        return directory.getId();
    }
}
