package com.atlassian.crowd.event.application;

import com.atlassian.crowd.event.Event;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ImmutableApplication;
import com.atlassian.crowd.model.token.Token;

public class ApplicationAuthenticatedEvent extends Event {
    private final ImmutableApplication application;
    private final Token token;

    public ApplicationAuthenticatedEvent(Object source, Application application, Token token) {
        super(source);
        this.application = ImmutableApplication.builder(application).build();
        this.token = token;
    }

    public Application getApplication() {
        return application;
    }

    public Token getToken() {
        return token;
    }

    // accessor for Analytics
    public Long getApplicationId() {
        return application.getId();
    }
}
