/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.event.listener;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.crowd.event.EventJobExecutionException;
import com.atlassian.crowd.event.LicenseResourceLimitEvent;
import com.atlassian.crowd.manager.license.CrowdLicenseManager;
import com.atlassian.crowd.manager.mail.MailManager;
import com.atlassian.crowd.manager.mail.MailSendException;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.manager.property.PropertyManagerException;
import com.atlassian.crowd.util.I18nHelper;
import com.atlassian.event.Event;
import com.atlassian.event.EventListener;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

public class LicenseResourceLimitListener
implements EventListener {
    private PropertyManager propertyManager;
    private CrowdLicenseManager crowdLicenseManager;
    private I18nHelper i18nHelper;
    private MailManager mailManager;
    private static final String MAILER_SUBJECT = "license.resource.limit.subject";
    private static final String LICENSE_RESOURCE_LIMIT_MESSAGE = "license.resource.limit.message";

    public void handleEvent(Event event) {
        LicenseResourceLimitEvent licenseResourceLimitEvent = (LicenseResourceLimitEvent)event;
        try {
            String email = this.propertyManager.getNotificationEmail();
            String subject = this.i18nHelper.getText(MAILER_SUBJECT);
            String body = this.i18nHelper.getText(LICENSE_RESOURCE_LIMIT_MESSAGE, (Object)EasyList.build((Object)this.crowdLicenseManager.getLicense().getMaximumNumberOfUsers(), (Object)licenseResourceLimitEvent.getCurrentUserCount()));
            this.mailManager.sendEmail(new InternetAddress(email), subject, body);
        }
        catch (MailSendException e) {
            throw new EventJobExecutionException(e.getMessage(), e);
        }
        catch (PropertyManagerException e) {
            throw new EventJobExecutionException(e.getMessage(), e);
        }
        catch (AddressException e) {
            throw new EventJobExecutionException(e.getMessage(), e);
        }
    }

    public Class[] getHandledEventClasses() {
        return new Class[]{LicenseResourceLimitEvent.class};
    }

    public void setPropertyManager(PropertyManager propertyManager) {
        this.propertyManager = propertyManager;
    }

    public void setI18nHelper(I18nHelper i18nHelper) {
        this.i18nHelper = i18nHelper;
    }

    public void setCrowdLicenseManager(CrowdLicenseManager crowdLicenseManager) {
        this.crowdLicenseManager = crowdLicenseManager;
    }

    public void setMailManager(MailManager mailManager) {
        this.mailManager = mailManager;
    }
}

