/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.event.listener;

import com.atlassian.crowd.event.user.UserCreatedEvent;
import com.atlassian.crowd.integration.directory.RemoteDirectory;
import com.atlassian.crowd.integration.exception.DirectoryInstantiationException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.model.directory.Directory;
import com.atlassian.crowd.model.directory.OperationType;
import com.atlassian.event.Event;
import com.atlassian.event.EventListener;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AutoGroupAdderListener
implements EventListener {
    private final Logger logger = Logger.getLogger(this.getClass());

    public void handleEvent(Event event) {
        UserCreatedEvent userCreatedEvent = (UserCreatedEvent)event;
        Directory directory = userCreatedEvent.getDirectory();
        String concatenatedGroupNames = directory.getAttribute("autoAddGroups");
        if (directory.getAllowedOperations().contains(OperationType.UPDATE_GROUP) && StringUtils.isNotBlank((String)concatenatedGroupNames)) {
            List<String> groups = Arrays.asList(concatenatedGroupNames.split("\\|"));
            try {
                RemoteDirectory remoteDirectory = directory.getImplementation();
                for (String groupName : groups) {
                    try {
                        remoteDirectory.addUserToGroup(userCreatedEvent.getUser().getName(), groupName);
                    }
                    catch (ObjectNotFoundException e) {
                        this.logger.error((Object)("Could not auto add user to group: " + e.getMessage()), (Throwable)e);
                    }
                }
            }
            catch (DirectoryInstantiationException e) {
                this.logger.error((Object)("Could not instantiate directory: " + e.getMessage()), (Throwable)e);
            }
        } else if (StringUtils.isNotBlank((String)concatenatedGroupNames)) {
            this.logger.error((Object)("You have groups <" + concatenatedGroupNames + "> to be auto-added for the user <" + userCreatedEvent.getUser().getName() + ">, but the directory does not have permission for Group updates."));
        }
    }

    public Class[] getHandledEventClasses() {
        return new Class[]{UserCreatedEvent.class};
    }
}

