/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.crypto;

import com.atlassian.crowd.crypto.EncryptionKeyFilePermissionChanger;
import com.atlassian.crowd.crypto.FileChecker;
import com.atlassian.crowd.exception.crypto.MissingKeyException;
import com.atlassian.crowd.manager.property.EncryptionSettings;
import com.atlassian.db.config.password.Cipher;
import com.atlassian.db.config.password.ciphers.algorithm.paramters.DecryptionParameters;
import com.atlassian.db.config.password.ciphers.algorithm.paramters.EncryptionParameters;
import com.google.gson.Gson;
import org.apache.commons.lang3.StringUtils;

class ClusterAwareCipherWrapper {
    static final String KEY_DIR_PLACEHOLDER = "KEY_DIR";
    private final EncryptionSettings encryptionSettings;
    private final Cipher cipher;
    private final FileChecker fileChecker;
    private final EncryptionKeyFilePermissionChanger encryptionKeyFilePermissionChanger;

    ClusterAwareCipherWrapper(EncryptionSettings encryptionSettings, Cipher cipher, FileChecker fileChecker, EncryptionKeyFilePermissionChanger encryptionKeyFilePermissionChanger) {
        this.encryptionSettings = encryptionSettings;
        this.cipher = cipher;
        this.fileChecker = fileChecker;
        this.encryptionKeyFilePermissionChanger = encryptionKeyFilePermissionChanger;
    }

    DecryptionParameters encrypt(EncryptionParameters encryptionParameters) {
        String keyFilePath = this.replacePlaceholderWithKeyDirPath(encryptionParameters.getKeyFilePath());
        if (keyFilePath != null && !this.fileChecker.fileExists(keyFilePath)) {
            throw new MissingKeyException(keyFilePath);
        }
        EncryptionParameters encryptionParametersWithResolvedKeyPath = new EncryptionParameters.Builder().setSaveAlgorithmParametersToSeparateFile(Boolean.valueOf(encryptionParameters.isSaveAlgorithmParametersToSeparateFile())).setSaveSealedObjectToSeparateFile(Boolean.valueOf(encryptionParameters.isSaveSealedObjectToSeparateFile())).setAlgorithm(encryptionParameters.getAlgorithm()).setAlgorithmKey(encryptionParameters.getAlgorithmKey()).setPlainTextPassword(encryptionParameters.getPlainTextPassword()).setOutputFilesBasePath(encryptionParameters.getOutputFilesBasePath()).setKeyFilePath(keyFilePath).build();
        Gson gson = new Gson();
        String decryptionParametersJson = this.cipher.encrypt(gson.toJson((Object)encryptionParametersWithResolvedKeyPath));
        DecryptionParameters encrypt = (DecryptionParameters)gson.fromJson(decryptionParametersJson, DecryptionParameters.class);
        this.encryptionKeyFilePermissionChanger.makeFileReadableOnlyByOwner(encrypt.getKeyFilePath());
        return new DecryptionParameters.Builder().serializedSealedObject(encrypt.getSerializedSealedObject()).setKeyFilePath(this.replaceKeyDirPathWithPlaceholder(encrypt.getKeyFilePath())).setSealedObjectFilePath(encrypt.getSealedObjectFilePath()).build();
    }

    String decrypt(DecryptionParameters decryptionParameters) {
        DecryptionParameters decryptionParametersWithPlaceholderInPath = new DecryptionParameters.Builder().serializedSealedObject(decryptionParameters.getSerializedSealedObject()).setKeyFilePath(this.replacePlaceholderWithKeyDirPath(decryptionParameters.getKeyFilePath())).setSealedObjectFilePath(decryptionParameters.getSealedObjectFilePath()).build();
        Gson gson = new Gson();
        return this.cipher.decrypt(gson.toJson((Object)decryptionParametersWithPlaceholderInPath));
    }

    private String replaceKeyDirPathWithPlaceholder(String path) {
        return StringUtils.replace((String)path, (String)this.encryptionSettings.getKeyFilesDirectoryPath(), (String)KEY_DIR_PLACEHOLDER);
    }

    private String replacePlaceholderWithKeyDirPath(String path) {
        return StringUtils.replace((String)path, (String)KEY_DIR_PLACEHOLDER, (String)this.encryptionSettings.getKeyFilesDirectoryPath());
    }
}

