package com.atlassian.crowd.crypto;

import com.atlassian.crowd.common.properties.EncryptionProperties;
import com.atlassian.crowd.embedded.api.Encryptor;
import com.atlassian.crowd.manager.property.EncryptionSettings;
import com.atlassian.db.config.password.DefaultCipherProvider;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DbConfigPasswordCipherEncryptorsFactory {

    public static final String AES_CBC_PKCS5PADDING = "AES_CBC_PKCS5Padding";
    public static final String DES_CBC_PKCS5PADDING = "DES_CBC_PKCS5Padding";
    public static final String DESEDE_CBC_PKCS5PADDING = "DESede_CBC_PKCS5Padding";

    private DbConfigPasswordCipherEncryptorsFactory() {
    }

    public static Map<String, Encryptor> createEncryptorsMap(EncryptionSettings encryptionSettings) {
        DefaultCipherProvider cipherProvider = new DefaultCipherProvider();

        Map<String, Encryptor> encryptors = new HashMap<>();
        // remember to use MissingKeyHandlingEncryptor, CachedEncryptor and SaltingEncryptor wrappers when it is appropriate
        encryptors.put(AES_CBC_PKCS5PADDING, createDbConfigPasswordCipherEncryptor("AES/CBC/PKCS5Padding", "AES", encryptionSettings, cipherProvider));
        encryptors.put(DES_CBC_PKCS5PADDING, createDbConfigPasswordCipherEncryptor("DES/CBC/PKCS5Padding", "DES", encryptionSettings, cipherProvider));
        encryptors.put(DESEDE_CBC_PKCS5PADDING, createDbConfigPasswordCipherEncryptor("DESede/CBC/PKCS5Padding", "DESede", encryptionSettings, cipherProvider));
        return Collections.unmodifiableMap(encryptors);
    }

    private static Encryptor createDbConfigPasswordCipherEncryptor(
            String algorithm, String algorithmKey, EncryptionSettings encryptionSettings, DefaultCipherProvider cipherProvider) {
        DbConfigPasswordCipherEncryptor encryptor = new DbConfigPasswordCipherEncryptor(algorithm, algorithmKey, encryptionSettings, cipherProvider);
        return new MissingKeyHandlingEncryptor(new SaltingEncryptor(new CachedEncryptor(encryptor,
                EncryptionProperties.ENCRYPTION_CACHE_MAX_SIZE.getValue(),
                EncryptionProperties.ENCRYPTION_CACHE_EXPIRATION.getValue(),
                EncryptionProperties.ENRCYPTION_CACHE_ENABLED::getValue)));
    }
}
