/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.core.event;

import com.atlassian.crowd.core.event.MultiEventPublisher;
import com.atlassian.crowd.core.event.TransactionAwareEventDispatcher;
import com.atlassian.crowd.core.event.TransactionAwareEventPublisher;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.event.config.EventThreadPoolConfiguration;
import com.atlassian.event.config.ListenerHandlersConfiguration;
import com.atlassian.event.internal.AnnotatedMethodsListenerHandler;
import com.atlassian.event.internal.DirectEventExecutorFactory;
import com.atlassian.event.internal.EventPublisherImpl;
import com.atlassian.event.internal.EventThreadPoolConfigurationImpl;
import com.atlassian.event.internal.ListenerHandlerConfigurationImpl;
import com.atlassian.event.spi.EventDispatcher;
import com.atlassian.event.spi.EventExecutorFactory;
import com.atlassian.event.spi.ListenerHandler;
import com.atlassian.plugin.event.PluginEventListener;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.transaction.PlatformTransactionManager;

public class CrowdEventPublisherFactory {
    private final PlatformTransactionManager transactionManager;

    public CrowdEventPublisherFactory(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public MultiEventPublisher createEventPublisher() {
        EventThreadPoolConfigurationImpl eventThreadPoolConfiguration = new EventThreadPoolConfigurationImpl();
        DirectEventExecutorFactory eventExecutorFactory = new DirectEventExecutorFactory((EventThreadPoolConfiguration)eventThreadPoolConfiguration);
        TransactionAwareEventDispatcher eventDispatcher = new TransactionAwareEventDispatcher((EventExecutorFactory)eventExecutorFactory, this.transactionManager);
        ListenerHandlerConfigurationImpl listenerHandlersConfiguration = new ListenerHandlerConfigurationImpl(){

            @Nonnull
            public List<ListenerHandler> getListenerHandlers() {
                return Lists.newArrayList((Object[])new ListenerHandler[]{new AnnotatedMethodsListenerHandler(), new AnnotatedMethodsListenerHandler(PluginEventListener.class)});
            }
        };
        EventPublisherImpl publisher = new EventPublisherImpl((EventDispatcher)eventDispatcher, (ListenerHandlersConfiguration)listenerHandlersConfiguration);
        return new TransactionAwareEventPublisher((EventPublisher)publisher);
    }
}

