/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.function;

import com.google.common.base.Throwables;
import java.util.function.Function;

public class ExceptionTranslators {
    public static <F, T> Function<F, T> toRuntimeException(FunctionWithException<F, T> function, Function<Exception, ? extends RuntimeException> exceptionTranslator) {
        return f -> {
            try {
                return function.get(f);
            }
            catch (Exception e) {
                Throwables.propagateIfPossible((Throwable)e);
                throw (RuntimeException)exceptionTranslator.apply(e);
            }
        };
    }

    public static <F, T> Function<F, T> toRuntimeException(FunctionWithException<F, T> function) {
        return ExceptionTranslators.toRuntimeException(function, RuntimeException::new);
    }

    public static interface FunctionWithException<F, T> {
        public T get(F var1) throws Exception;
    }
}

