package com.atlassian.crowd.validator;

import java.util.List;
import java.util.function.Function;

/**
 * Email address validator compatible with Atlassian Cloud.
 */
public class CloudCompatibleEmailValidator implements EmailAddressValidator {
    private final com.atlassian.ccev.EmailValidator emailValidator = new com.atlassian.ccev.EmailValidator();

    @Override
    public boolean isValidSyntax(String emailAddress) {
        return emailValidator.validate(emailAddress);
    }

    @Override
    public long validateSyntax(List<String> emailAddresses) {
        return emailValidator.validate(emailAddresses, Function.identity()).stream().filter(result -> !result.isValid()).count();
    }

    @Override
    public long findDuplicates(List<String> emailAddresses) {
        return emailValidator.validate(emailAddresses, Function.identity()).stream()
                .filter(com.atlassian.ccev.EmailValidator.Result::isDuplicated).count();
    }
}
