package com.atlassian.crowd.manager.application.search;

import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;

import java.util.Collections;
import java.util.List;

/**
 * A {@link MembershipSearchStrategy} for an application with no active directories associated.
 *
 * @since 2.9
 */
public enum NoDirectorySearchStrategy implements UserSearchStrategy, GroupSearchStrategy, MembershipSearchStrategy {
    INSTANCE;

    @Override
    public <T> List<T> searchUsers(EntityQuery<T> query) {
        return Collections.emptyList();
    }

    @Override
    public <T> List<T> searchGroups(EntityQuery<T> query) {
        return Collections.emptyList();
    }

    @Override
    public <T> List<T> searchDirectGroupRelationships(MembershipQuery<T> query) {
        return Collections.emptyList();
    }

    @Override
    public <T> List<T> searchNestedGroupRelationships(MembershipQuery<T> query) {
        return Collections.emptyList();
    }

    @Override
    public <T> ListMultimap<String, T> searchDirectGroupRelationshipsGroupedByName(MembershipQuery<T> query) {
        return ImmutableListMultimap.of();
    }


}
