package com.atlassian.crowd.manager.application.search;

import com.atlassian.crowd.search.query.entity.EntityQuery;

import java.util.List;

/**
 * A set of querying across a collection of active directories.
 * <p>
 * A strategy is resolved using a {@link SearchStrategyFactory} and can be optimised for specific configurations of
 * directory.
 *
 * @see SearchStrategyFactory
 */
public interface GroupSearchStrategy {
    /**
     * Returns a {@code List<Group>} or {@code List<String>} groupnames matching the search criteria defined in the query.
     * <p>
     * The groups will be returned in a stable order including across pagination boundaries (excluding modification).
     *
     * @param query the search query.
     * @return {@code List<Group>} group objects or {@code List<String>} groupnames, depending on the query.
     */
    <T> List<T> searchGroups(EntityQuery<T> query);
}
