package com.atlassian.crowd.manager.application.filtering;

import com.atlassian.crowd.model.application.Application;

/**
 * Factory for {@link AccessFilter}.
 */
public interface AccessFilterFactory {
    /**
     * Creates {@link AccessFilter} for the given {@code application}.
     *
     * @param application      application for which access based filtering should be applied
     * @param queryForAllUsers whether all users with access should be fetched in a single query; setting to true makes
     *                         sense when {@link AccessFilter} will be used for multiple queries
     * @return {@link AccessFilter} for the given {@code application}
     */
    AccessFilter create(Application application, boolean queryForAllUsers);
}
