package com.atlassian.crowd.manager.application.filtering;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.manager.application.search.DirectoryQueryWithFilter;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.membership.MembershipQuery;

import java.util.Optional;
import java.util.function.UnaryOperator;

/**
 * Interface for filtering users and groups with access.
 */
public interface AccessFilter {
    AccessFilter UNFILTERED = new AccessFilter() {
        @Override
        public boolean requiresFiltering(Entity entity) {
            return false;
        }

        @Override
        public <T> Optional<DirectoryQueryWithFilter<T>> getDirectoryQueryWithFilter(Directory directory, EntityQuery<T> query) {
            return Optional.of(new DirectoryQueryWithFilter<>(directory, query, UnaryOperator.identity()));
        }

        @Override
        public <T> Optional<DirectoryQueryWithFilter<T>> getDirectoryQueryWithFilter(Directory directory, MembershipQuery<T> query) {
            return Optional.of(new DirectoryQueryWithFilter<>(directory, query, UnaryOperator.identity()));
        }

        @Override
        public boolean hasAccess(long directoryId, Entity entity, String name) {
            return true;
        }
    };

    /**
     * @return whether filtering is required for the given entity type
     */
    boolean requiresFiltering(Entity entity);

    /**
     * @return effective query that should be run for the given directory and provided original query, or
     * {@link Optional#empty()} if emtpy results should be returned
     */
    <T> Optional<DirectoryQueryWithFilter<T>> getDirectoryQueryWithFilter(Directory directory, EntityQuery<T> query);

    /**
     * @return effective query that should be run for the given directory and provided original query, or
     * {@link Optional#empty()} if emtpy results should be returned
     */
    <T> Optional<DirectoryQueryWithFilter<T>> getDirectoryQueryWithFilter(Directory directory, MembershipQuery<T> query);

    /**
     * @return whether entity with the given name has access
     */
    boolean hasAccess(long directoryId, Entity entity, String name);
}
