package com.atlassian.crowd.function;

import com.google.common.base.Throwables;

import java.util.function.Function;

/**
 * Utility class transforming lambdas with checked exceptions to lambdas without exceptions.
 */
public class ExceptionTranslators {
    public interface FunctionWithException<F, T> {
        T get(F f) throws Exception;
    }

    public static <F, T> Function<F, T> toRuntimeException(
            FunctionWithException<F, T> function, Function<Exception, ? extends RuntimeException> exceptionTranslator) {
        return (f) -> {
            try {
                return function.get(f);
            } catch (Exception e) {
                Throwables.propagateIfPossible(e);
                throw exceptionTranslator.apply(e);
            }
        };
    }

    public static <F, T> Function<F, T> toRuntimeException(FunctionWithException<F, T> function) {
        return toRuntimeException(function, RuntimeException::new);
    }
}
