package com.atlassian.crowd.core.event.listener;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.user.UserWithAttributes;

import java.util.Collection;

/**
 * Resolves default groups which user should be added to during authentication
 * @since 3.1.0
 */
public interface DefaultGroupMembershipResolver {
    /**
     * Returns the default group memberships to which the user authenticating to the specified application should be added to.
     * @param application the application which user authenticates against
     * @param directory the user's directory
     * @param user the user
     * @return a collection of group names
     */
    Collection<String> getDefaultGroupNames(Application application, Directory directory, UserWithAttributes user);

    /**
     * The callback that should be called after adding the user to all the default groups returned from this DefaultGroupMembershipResolver
     * @param application the application user authenticated against
     * @param directory the user's directory
     * @param user the user
     * @throws OperationFailedException
     */
    void onDefaultGroupsAdded(Application application, Directory directory, UserWithAttributes user) throws OperationFailedException;
}