package com.atlassian.crowd.mapper;

import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectReader;
import org.codehaus.jackson.map.ObjectWriter;

import javax.annotation.Nullable;
import java.io.IOException;

/**
 * Simplified version of {@link ObjectMapper} that has following advantages over {@link ObjectMapper}:
 * <ul>
 * <li>It's fully thread-safe, as it uses {@link ObjectReader} and {@link ObjectWriter} which are immutable</li>
 * <li>Is not prone to performance problems under heavy load</li>
 * </ul>
 */
public class SimpleObjectMapper<T> {
    private final ObjectReader reader;
    private final ObjectWriter writer;

    public SimpleObjectMapper(Class<T> clz) {
        this(new ObjectMapper(), clz);
    }

    public SimpleObjectMapper(ObjectMapper mapper, Class<T> clz) {
        this.reader = mapper.reader(clz);
        this.writer = mapper.writerWithType(clz);
    }

    public String serialize(T t) throws IOException {
        return writer.writeValueAsString(t);
    }

    public T deserialize(final @Nullable String syncToken) throws IOException {
        return reader.readValue(syncToken);
    }
}
