package com.atlassian.crowd.manager.tombstone;

import java.time.Duration;
import java.time.Instant;

import com.atlassian.crowd.dao.tombstone.TombstoneDao;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class TombstoneManagerImpl implements TombstoneManager {
    /**
     * The time after which tombstones get removed from persisted storage
     */
    public static final Duration TOMBSTONE_LIFETIME = Duration.ofDays(7);

    private static final Logger log = LoggerFactory.getLogger(TombstoneManagerImpl.class);
    private final TombstoneDao tombstoneDao;

    public TombstoneManagerImpl(TombstoneDao tombstoneDao) {
        this.tombstoneDao = tombstoneDao;
    }

    @Override
    public void removeOldTombstones() {

        final Instant cutoff = Instant.now().minus(TOMBSTONE_LIFETIME);
        removeTombstonesOlderThan(cutoff);
    }

    @Override
    public void removeTombstonesOlderThan(Instant cutoff) {
        log.debug("Removing tombstones created before {}", cutoff);
        final int removed = tombstoneDao.removeAllUpTo(cutoff.toEpochMilli());
        log.debug("Done tombstone pruning job, removed {} tombstones", removed);
    }
}