package com.atlassian.crowd.manager.directory.nestedgroups;

import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.model.group.Group;

import java.util.Collection;
import java.util.List;

/**
 * Provides directly related groups (e.g. direct parents or children) of the given group.
 */
public interface NestedGroupsProvider {
    /**
     * Returns list of directly related groups (e.g. direct parents or children) for a given identifiers of groups.
     */
    List<Group> getDirectlyRelatedGroups(Collection<String> ids) throws OperationFailedException;

    /**
     * Returns identifier of group that will be passed to {@link #getDirectlyRelatedGroups(Collection)}. Usually this should be
     * {@link Group#getName()} or {@link Group#getExternalId()}.
     */
    String getIdentifierForSubGroupsQuery(Group group);

    /**
     * Normalizes the identifier for de-duplication.
     */
    String normalizeIdentifier(String id);

    /**
     * Maximum number of groups passed to {@link #getDirectlyRelatedGroups(Collection)}
     */
    int getMaxBatchSize();
}
