package com.atlassian.crowd.manager.directory;


import com.atlassian.crowd.event.application.ApplicationReadyEvent;
import com.atlassian.crowd.service.cluster.ClusterService;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventListenerRegistrar;
import org.slf4j.Logger;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

import static org.slf4j.LoggerFactory.getLogger;

/**
 * Marks incomplete synchronization as failed for single-node instances. Only relevant for non-clustered configurations.
 * @see FailedSynchronisationManager#rescheduleStalledSynchronisations() for handling in cluster.
 */
public class SynchronisationStatusFinalizer {
    private static final Logger log = getLogger(SynchronisationStatusFinalizer.class);

    private final EventListenerRegistrar eventListenerRegistrar;
    private final FailedSynchronisationManager failedSynchronisationManager;
    private final ClusterService clusterService;

    public SynchronisationStatusFinalizer(EventListenerRegistrar eventListenerRegistrar,
                                          FailedSynchronisationManager failedSynchronisationManager,
                                          ClusterService clusterService) {
        this.eventListenerRegistrar = eventListenerRegistrar;
        this.failedSynchronisationManager = failedSynchronisationManager;
        this.clusterService = clusterService;
    }

    @PostConstruct
    public void register() {
        eventListenerRegistrar.register(this);
    }

    @PreDestroy
    public void unregister() {
        eventListenerRegistrar.unregister(this);
    }

    @EventListener
    public void handleEvent(ApplicationReadyEvent applicationReadyEvent) {
        if (clusterService.isAvailable()) {
            log.debug("Not updating synchronisation status on startup in clustered configuration");
            return;
        }
        failedSynchronisationManager.finalizeSynchronisationStatuses();
    }

}
