package com.atlassian.crowd.manager.directory;

import com.atlassian.crowd.embedded.spi.DirectorySynchronisationTokenDao;
import com.atlassian.crowd.exception.DirectoryNotFoundException;

import javax.annotation.Nullable;

/**
 * A persistent implementation of the {@link DirectorySynchronisationTokenStore} that uses the database for token
 * storage
 */
public class InDatabaseDirectorySynchronisationTokenStore implements DirectorySynchronisationTokenStore {

    private final DirectorySynchronisationTokenDao directorySynchronisationTokenDao;

    public InDatabaseDirectorySynchronisationTokenStore(
            final DirectorySynchronisationTokenDao directorySynchronisationTokenDao) {
        this.directorySynchronisationTokenDao = directorySynchronisationTokenDao;
    }

    @Override
    @Nullable
    public String getLastSynchronisationTokenForDirectory(final long directoryId) {
        return directorySynchronisationTokenDao.getLastSynchronisationTokenForDirectory(directoryId);
    }

    @Override
    public void storeSynchronisationTokenForDirectory(final long directoryId, final String syncStatus) {
        try {
            directorySynchronisationTokenDao.storeSynchronisationTokenForDirectory(directoryId, syncStatus);
        } catch (DirectoryNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void clearSynchronisationTokenForDirectory(final long directoryId) {
        directorySynchronisationTokenDao.clearSynchronisationTokenForDirectory(directoryId);
    }
}
