package com.atlassian.crowd.crypto;

import com.atlassian.crowd.embedded.api.Encryptor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class BasicEncryptorsFactory {
    private BasicEncryptorsFactory() {
    }

    public static final String BASE_64_ENCRYPTOR = "BASE64";

    public static Map<String, Encryptor> createEncryptors() {
        Map<String, Encryptor> encryptors = new HashMap<>();
        encryptors.put(BASE_64_ENCRYPTOR, new Base64Encryptor());
        return Collections.unmodifiableMap(encryptors);
    }
}
