package com.atlassian.crowd.crypto;

import com.atlassian.crowd.embedded.api.Encryptor;

import java.util.Base64;

/**
 * Encryptor that uses base64 to encode and decode input string.
 * This implementation is not a safe encryption mechanism. Do not use it in production!
 */
public class Base64Encryptor implements Encryptor {

    @Override
    public String encrypt(String password) {
        return new String(Base64.getEncoder().encode(password.getBytes()));
    }

    @Override
    public String decrypt(String encryptedPassword) {
        try {
            return new String(Base64.getDecoder().decode(encryptedPassword.getBytes()));
        } catch (IllegalArgumentException e) {
            return encryptedPassword;
        }
    }
}
