package com.atlassian.crowd.core.event;

import com.atlassian.event.config.EventThreadPoolConfiguration;
import com.atlassian.event.config.ListenerHandlersConfiguration;
import com.atlassian.event.internal.AnnotatedMethodsListenerHandler;
import com.atlassian.event.internal.DirectEventExecutorFactory;
import com.atlassian.event.internal.EventPublisherImpl;
import com.atlassian.event.internal.EventThreadPoolConfigurationImpl;
import com.atlassian.event.internal.ListenerHandlerConfigurationImpl;
import com.atlassian.event.spi.EventDispatcher;
import com.atlassian.event.spi.EventExecutorFactory;

import com.atlassian.event.spi.ListenerHandler;
import com.atlassian.plugin.event.PluginEventListener;
import com.google.common.collect.Lists;
import org.springframework.transaction.PlatformTransactionManager;

import javax.annotation.Nonnull;
import java.util.List;

/**
 * Factory for event publisher instances.
 */
public class CrowdEventPublisherFactory {
    private final PlatformTransactionManager transactionManager;

    public CrowdEventPublisherFactory(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public MultiEventPublisher createEventPublisher() {
        final EventThreadPoolConfiguration eventThreadPoolConfiguration = new EventThreadPoolConfigurationImpl();
        final EventExecutorFactory eventExecutorFactory = new DirectEventExecutorFactory(eventThreadPoolConfiguration);
        final EventDispatcher eventDispatcher = new TransactionAwareEventDispatcher(eventExecutorFactory, transactionManager);
        final ListenerHandlersConfiguration listenerHandlersConfiguration = new ListenerHandlerConfigurationImpl() {
            @Nonnull
            @Override
            public List<ListenerHandler> getListenerHandlers() {
                return Lists.newArrayList(new AnnotatedMethodsListenerHandler(),
                        new AnnotatedMethodsListenerHandler(PluginEventListener.class));
            }
        };

        EventPublisherImpl publisher = new EventPublisherImpl(eventDispatcher, listenerHandlersConfiguration);

        return new TransactionAwareEventPublisher(publisher);
    }
}
