package com.atlassian.crowd.manager.property;

import com.atlassian.crowd.manager.rememberme.CrowdSpecificRememberMeSettings;

import java.util.Collection;
import java.util.List;

/**
 * Internal API for storing and retrieving Crowd server properties.
 *
 * @since 3.3.0
 */
public interface InternalPropertyManager extends PropertyManager {

    /**
     * @return List of notification emails.
     * @throws PropertyManagerException property does not exist
     *
     * @since 3.3.0
     */
    Collection<String> getNotificationEmails() throws PropertyManagerException;

    /**
     * Sets notification emails.
     * @param notificationEmails list of notification emails.
     *
     * @since 3.3.0
     */
    void setNotificationEmails(List<String> notificationEmails);

    /**
     * Sets remember me configuration
     * @param configuration new configuration
     */
    void setRememberMeConfiguration(CrowdSpecificRememberMeSettings configuration);

    /**
     * Retrieves remember me configuration
     * @return current configuration
     */
    CrowdSpecificRememberMeSettings getRememberMeConfiguration();
}
