package com.atlassian.crowd.manager.directory.monitor;

import com.atlassian.crowd.directory.RemoteDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoopDirectoryMonitorManager implements DirectoryMonitorManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public NoopDirectoryMonitorManager() {
    }

    public void addMonitor(RemoteDirectory remoteDirectory) {
        logger.info("DirectoryMonitorManager is no longer supported, ignoring request to add monitor for directory " + remoteDirectory.getDirectoryId());
    }

    public boolean removeMonitor(long directoryID) {
        logger.info("DirectoryMonitorManager is no longer supported, ignoring request to remove monitor for directory " + directoryID);
        return false;
    }

    public boolean hasMonitor(long directoryID) {
        logger.info("DirectoryMonitorManager is no longer supported, returning true on hasMonitor() checked for directory " + directoryID);
        return true;
    }
}
