package com.atlassian.crowd.manager.directory;

import com.atlassian.crowd.embedded.api.DirectorySynchronisationInformation;
import com.atlassian.crowd.embedded.api.DirectorySynchronisationRoundInformation;
import com.atlassian.crowd.model.directory.DirectorySynchronisationStatus;
import com.atlassian.crowd.model.directory.SynchronisationStatusKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Function;

@Deprecated
public class DirectorySynchronisationInformationStoreImpl implements DirectorySynchronisationInformationStore {
    private static final Logger log = LoggerFactory.getLogger(DirectorySynchronisationInformationStoreImpl.class);

    private static final DirectorySynchronisationInformation EMPTY_INFO = new DirectorySynchronisationInformation(null, null);

    private final ConcurrentMap<Long, DirectorySynchronisationInformation> syncStatus;

    public DirectorySynchronisationInformationStoreImpl() {
        this(new ConcurrentHashMap<>());
    }

    /**
     * Construct a {@link DirectorySynchronisationInformationStoreImpl} which is backed by a concurrent map.
     * <p>
     * This constructor can be used to achieve cluster safety in cluster-capable applications by providing a
     * cluster-aware implementation
     *
     * @since 2.8
     */
    public DirectorySynchronisationInformationStoreImpl(ConcurrentMap<Long, DirectorySynchronisationInformation> syncStatus) {
        this.syncStatus = syncStatus;
    }

    @Override
    public DirectorySynchronisationRoundInformation getActive(long directoryId) {
        return get(directoryId).getActiveRound();
    }

    @Override
    public Optional<DirectorySynchronisationRoundInformation> getLast(long directoryId) {
        return Optional.ofNullable(get(directoryId).getLastRound());
    }

    @Override
    public void clear(long directoryId) {
        syncStatus.remove(directoryId);
    }

    @Override
    public void clear() {
        syncStatus.clear();
    }

    @Override
    public void syncStatus(long directoryId, String statusKey, List<Serializable> parameters) {
        updateActiveRoundUsingBuilder(directoryId, builder -> builder.setStatusKey(statusKey).setStatusParameters(parameters));
    }

    @Override
    public void syncStatus(long directoryId, SynchronisationStatusKey statusKey, List<Serializable> parameters) {
        syncStatus(directoryId, statusKey.getI18Key(), parameters);
    }

    @Override
    public void syncStarted(long directoryId, long timestamp) {
        updateActiveRound(directoryId, ignore ->
                new DirectorySynchronisationRoundInformation(timestamp, -1L, SynchronisationStatusKey.STARTED.getI18Key(), Collections.emptyList()));
    }

    @Override
    public void syncFinished(long directoryId, long timestamp, SynchronisationStatusKey statusKey, List<Serializable> parameters) {
        final DirectorySynchronisationRoundInformation current = get(directoryId).getActiveRound();
        final DirectorySynchronisationRoundInformation.Builder builder;
        if (current != null) {
            builder = DirectorySynchronisationRoundInformation.builder(current)
                    .setDurationMs(timestamp - current.getStartTime());

        } else {
            builder = DirectorySynchronisationRoundInformation.builder()
                    .setStartTime(timestamp)
                    .setDurationMs(0);
        }
        builder.setStatusKey(statusKey.getI18Key())
                .setStatusParameters(parameters);
        syncStatus.put(directoryId, new DirectorySynchronisationInformation(builder.build(), null));
    }

    @Override
    public void syncFailure(long directoryId, SynchronisationMode syncMode, String failureReason) {
        updateActiveRoundUsingBuilder(directoryId, syncMode == SynchronisationMode.INCREMENTAL
                ? builder -> builder.setIncrementalSyncError(failureReason) : builder -> builder.setFullSyncError(failureReason));
    }

    private void updateActiveRoundUsingBuilder(long directoryId, Consumer<DirectorySynchronisationRoundInformation.Builder> builderConsumer) {
        updateActiveRound(directoryId, active -> {
            final DirectorySynchronisationRoundInformation.Builder builder;
            if (active == null) {
                builder = DirectorySynchronisationRoundInformation.builder()
                        .setStartTime(System.currentTimeMillis())
                        .setDurationMs(-1);
            } else {
                builder = DirectorySynchronisationRoundInformation.builder(active);
            }
            builderConsumer.accept(builder);
            return builder.build();
        });
    }

    private void updateActiveRound(long directoryId, Function<DirectorySynchronisationRoundInformation, DirectorySynchronisationRoundInformation> transformer) {
        final DirectorySynchronisationInformation info = get(directoryId);
        syncStatus.put(directoryId, new DirectorySynchronisationInformation(info.getLastRound(), transformer.apply(info.getActiveRound())));
    }

    @Override
    public Collection<DirectorySynchronisationStatus> getStalledSynchronizations() {
        log.debug("Called non database implementation of getStalledSynchronizations - ignoring");
        return Collections.emptyList();
    }

    public DirectorySynchronisationInformation get(long directoryId) {
        return syncStatus.getOrDefault(directoryId, EMPTY_INFO);
    }
}