package com.atlassian.crowd.manager.application.search;

import com.atlassian.crowd.search.query.entity.EntityQuery;

import java.util.List;

/**
 * A set of querying across a collection of active directories.
 * <p>
 * A strategy is resolved using a {@link SearchStrategyFactory} and can be optimised for specific configurations of
 * directory.
 *
 * @see SearchStrategyFactory
 */
public interface UserSearchStrategy {
    /**
     * Returns a {@code List<User>} or {@code List<String>} matching the search criteria defined in the query.
     * <p>
     * The users will be returned in a stable order including across pagination boundaries (excluding modification).
     *
     * @param query the search query.
     * @return {@code List<User>} user objects or {@code List<String>} usernames, depending on the query.
     */
    <T> List<T> searchUsers(EntityQuery<T> query);
}
