package com.atlassian.crowd.manager.application;

import com.atlassian.crowd.dao.application.ApplicationDefaultGroupMembershipConfigurationDao;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.DirectoryMappingNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationDefaultGroupMembershipConfiguration;
import com.atlassian.crowd.model.application.ApplicationDirectoryMapping;
import com.google.common.collect.ImmutableList;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.stream.Collectors;

@Transactional
public class DefaultGroupMembershipServiceImpl implements DefaultGroupMembershipService {

    private final ApplicationDefaultGroupMembershipConfigurationDao applicationDefaultGroupMembershipConfigurationDao;

    public DefaultGroupMembershipServiceImpl(final ApplicationDefaultGroupMembershipConfigurationDao applicationDefaultGroupMembershipConfigurationDao) {
        this.applicationDefaultGroupMembershipConfigurationDao = applicationDefaultGroupMembershipConfigurationDao;
    }

    @Override
    public void add(final Application application, final ApplicationDirectoryMapping directoryMapping, final String groupName) throws OperationFailedException {
        try {
            applicationDefaultGroupMembershipConfigurationDao.add(application, directoryMapping, groupName);
        } catch (DirectoryMappingNotFoundException | ApplicationNotFoundException e) {
            throw new OperationFailedException(e);
        }
    }

    @Override
    public void remove(final Application application, final ApplicationDirectoryMapping directoryMapping, final String groupName) throws OperationFailedException {
        try {
            applicationDefaultGroupMembershipConfigurationDao.remove(application, directoryMapping, groupName);
        } catch (DirectoryMappingNotFoundException | ApplicationNotFoundException e) {
            throw new OperationFailedException(e);
        }
    }

    @Override
    public List<String> listAll(final Application application, final ApplicationDirectoryMapping directoryMapping) throws OperationFailedException {
        try {
            return ImmutableList.copyOf(applicationDefaultGroupMembershipConfigurationDao.listAll(application, directoryMapping).stream()
                    .map(ApplicationDefaultGroupMembershipConfiguration::getGroupName)
                    .collect(Collectors.toList()));
        } catch (DirectoryMappingNotFoundException | ApplicationNotFoundException e) {
            throw new OperationFailedException(e);
        }
    }
}
