package com.atlassian.crowd.crypto;

import com.atlassian.crowd.embedded.api.Encryptor;
import com.atlassian.crowd.exception.crypto.MissingKeyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MissingKeyHandlingEncryptor implements Encryptor {

    private static final Logger log = LoggerFactory.getLogger(MissingKeyHandlingEncryptor.class);

    private final Encryptor delegate;

    public MissingKeyHandlingEncryptor(Encryptor delegate) {
        this.delegate = delegate;
    }

    @Override
    public String encrypt(String password) {
        try {
            return delegate.encrypt(password);
        } catch (MissingKeyException e) {
            log.warn("Encryption key {} is missing. Generating new key.", e.getMessage());
            delegate.changeEncryptionKey();
            return delegate.encrypt(password);
        }
    }

    @Override
    public String decrypt(String encryptedPassword) {
        return delegate.decrypt(encryptedPassword);
    }

    @Override
    public boolean changeEncryptionKey() {
        return delegate.changeEncryptionKey();
    }
}
