/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.recovery;

import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.event.recovery.RecoveryModeActivatedEvent;
import com.atlassian.crowd.manager.recovery.RecoveryModeDirectory;
import com.atlassian.crowd.manager.recovery.RecoveryModeService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemPropertyRecoveryModeService
implements RecoveryModeService {
    private static final Logger logger = LoggerFactory.getLogger(SystemPropertyRecoveryModeService.class);
    static final String RECOVERY_USERNAME = "recovery_admin";
    static final String RECOVERY_DISPLAY_NAME = "Recovery Admin User";
    static final String RECOVERY_EMAIL = "@";
    @VisibleForTesting
    public static final String PROP_RECOVERY_PASSWORD = "atlassian.recovery.password";
    private final DirectoryInstanceLoader loader;
    private final EventPublisher eventPublisher;
    private final AtomicBoolean recoveryModeEventRaised = new AtomicBoolean();
    private final LazyReference<String> recoveryPasswordRef = new LazyReference<String>(){

        protected String create() throws Exception {
            return System.getProperty(SystemPropertyRecoveryModeService.PROP_RECOVERY_PASSWORD);
        }
    };
    private final LazyReference<RecoveryModeDirectory> recoveryDirectoryRef = new LazyReference<RecoveryModeDirectory>(){

        protected RecoveryModeDirectory create() throws Exception {
            return new RecoveryModeDirectory(SystemPropertyRecoveryModeService.RECOVERY_USERNAME, (String)SystemPropertyRecoveryModeService.this.recoveryPasswordRef.get());
        }
    };

    public SystemPropertyRecoveryModeService(DirectoryInstanceLoader loader, EventPublisher eventPublisher) {
        this.loader = (DirectoryInstanceLoader)Preconditions.checkNotNull((Object)loader, (Object)"loader");
        this.eventPublisher = (EventPublisher)Preconditions.checkNotNull((Object)eventPublisher, (Object)"eventPublisher");
    }

    @Override
    public boolean isRecoveryModeOn() {
        boolean recoveryModeOn;
        boolean bl = recoveryModeOn = this.isRecoveryFeatureOn() && StringUtils.isNotBlank((CharSequence)this.getRecoveryPassword());
        if (this.recoveryModeEventRaised.compareAndSet(false, true)) {
            if (recoveryModeOn) {
                logger.info("Recovery mode is ON");
                this.eventPublisher.publish((Object)new RecoveryModeActivatedEvent(RECOVERY_USERNAME, this.getRecoveryDirectory()));
            } else if (StringUtils.isNotBlank((CharSequence)this.getRecoveryPassword()) && !this.isRecoveryFeatureOn()) {
                logger.warn("Attempt has been made to activate recovery mode, but the host application does not support it yet");
            }
        }
        return recoveryModeOn;
    }

    @Override
    public Directory getRecoveryDirectory() {
        Preconditions.checkState((boolean)this.isRecoveryModeOn(), (Object)"Recovery Mode is not ON");
        return (Directory)this.recoveryDirectoryRef.get();
    }

    @Override
    public String getRecoveryUsername() {
        Preconditions.checkState((boolean)this.isRecoveryModeOn(), (Object)"Recovery Mode is not ON");
        return RECOVERY_USERNAME;
    }

    @Override
    public boolean isRecoveryDirectory(Directory directory) {
        return directory.getId().equals(-2L);
    }

    private boolean isRecoveryFeatureOn() {
        return this.loader.canLoad(RecoveryModeDirectory.class.getName());
    }

    private String getRecoveryPassword() {
        return (String)this.recoveryPasswordRef.get();
    }
}

