/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.directory;

import com.atlassian.crowd.directory.SynchronisableDirectory;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.event.directory.DirectoryUpdatedEvent;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.manager.directory.DirectorySynchronisationInformationStore;
import com.atlassian.crowd.manager.directory.DirectorySynchroniserHelper;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import java.util.HashMap;
import java.util.Map;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class DirectorySynchroniserHelperImpl
implements DirectorySynchroniserHelper {
    private final DirectoryDao directoryDao;
    private final DirectorySynchronisationInformationStore informationStore;

    public DirectorySynchroniserHelperImpl(DirectoryDao directoryDao, EventPublisher eventPublisher, DirectorySynchronisationInformationStore informationStore) {
        this.directoryDao = directoryDao;
        this.informationStore = informationStore;
        eventPublisher.register((Object)this);
    }

    @Override
    public void updateSyncStartTime(SynchronisableDirectory synchronisableDirectory) throws DirectoryNotFoundException {
        Directory directory = this.findDirectoryById(synchronisableDirectory.getDirectoryId());
        HashMap<String, String> attributes = new HashMap<String, String>(directory.getAttributes());
        attributes.put("com.atlassian.crowd.directory.sync.currentstartsynctime", String.valueOf(System.currentTimeMillis()));
        attributes.put("com.atlassian.crowd.directory.sync.issynchronising", Boolean.TRUE.toString());
        this.updateAttributes(directory, attributes);
    }

    @Override
    public void updateSyncEndTime(SynchronisableDirectory synchronisableDirectory) throws DirectoryNotFoundException {
        Directory directory = this.findDirectoryById(synchronisableDirectory.getDirectoryId());
        HashMap<String, String> directoryAttributes = new HashMap<String, String>(directory.getAttributes());
        String startTime = (String)directoryAttributes.get("com.atlassian.crowd.directory.sync.currentstartsynctime");
        if (startTime == null) {
            throw new IllegalStateException("Updating end time with no current start synchronisation time.");
        }
        String duration = String.valueOf(System.currentTimeMillis() - Long.parseLong(startTime));
        directoryAttributes.put("com.atlassian.crowd.directory.sync.laststartsynctime", startTime);
        directoryAttributes.put("com.atlassian.crowd.directory.sync.lastdurationms", duration);
        directoryAttributes.put("com.atlassian.crowd.directory.sync.currentstartsynctime", null);
        directoryAttributes.put("com.atlassian.crowd.directory.sync.issynchronising", Boolean.FALSE.toString());
        this.updateAttributes(directory, directoryAttributes);
    }

    @Override
    public boolean isSynchronising(long synchronisableDirectoryId) throws DirectoryNotFoundException {
        Directory directory = this.findDirectoryById(synchronisableDirectoryId);
        String isSynchronising = (String)directory.getAttributes().get("com.atlassian.crowd.directory.sync.issynchronising");
        return isSynchronising != null && Boolean.valueOf(isSynchronising) != false;
    }

    private void updateAttributes(Directory directory, Map<String, String> attributes) throws DirectoryNotFoundException {
        DirectoryImpl newDirectory = new DirectoryImpl(directory);
        newDirectory.setAttributes(attributes);
        this.directoryDao.update((Directory)newDirectory);
    }

    @Override
    public Directory findDirectoryById(long directoryId) throws DirectoryNotFoundException {
        return this.directoryDao.findById(directoryId);
    }

    @EventListener
    public void handleEvent(DirectoryUpdatedEvent event) {
        try {
            Directory directory = this.directoryDao.findById(event.getDirectoryId().longValue());
            HashMap<String, String> directoryAttributes = new HashMap<String, String>(directory.getAttributes());
            directoryAttributes.remove("com.atlassian.crowd.directory.sync.issynchronising");
            directoryAttributes.put("configuration.change.timestamp", Long.toString(System.currentTimeMillis()));
            this.updateAttributes(directory, directoryAttributes);
        }
        catch (DirectoryNotFoundException directoryNotFoundException) {
            // empty catch block
        }
    }
}

