/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.application;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.manager.application.GroupSearchStrategy;
import com.atlassian.crowd.manager.application.InMemorySearchUtils;
import com.atlassian.crowd.manager.application.SingleDirectorySearchStrategy;
import com.atlassian.crowd.manager.application.UserSearchStrategy;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.util.ResultsAggregator;
import com.atlassian.crowd.search.util.ResultsAggregators;
import com.google.common.base.Function;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class InMemoryEntitySearchStrategy
implements UserSearchStrategy,
GroupSearchStrategy {
    protected final DirectoryManager directoryManager;
    protected final List<Directory> directories;
    private final boolean mergeEntities;

    public InMemoryEntitySearchStrategy(DirectoryManager directoryManager, List<Directory> directories, boolean mergeEntities) {
        this.directoryManager = directoryManager;
        this.directories = directories;
        this.mergeEntities = mergeEntities;
    }

    @Override
    public <T> List<T> searchUsers(EntityQuery<T> query) {
        return this.search(query, UserSearchStrategy::searchUsers);
    }

    @Override
    public <T> List<T> searchGroups(EntityQuery<T> query) {
        return this.search(query, GroupSearchStrategy::searchGroups);
    }

    protected <T> List<T> search(EntityQuery<T> query, BiFunction<SingleDirectorySearchStrategy, EntityQuery<T>, List<T>> provider) {
        return this.mergeEntities ? this.searchMerging(query, provider) : this.searchNonMerging(query, provider);
    }

    protected <T> List<T> searchMerging(EntityQuery<T> query, BiFunction<SingleDirectorySearchStrategy, EntityQuery<T>, List<T>> provider) {
        Function cmp = InMemorySearchUtils.getMergingAggregatingAndSortingComparatorFor(query.getReturnType());
        ResultsAggregator results = ResultsAggregators.with(cmp, query);
        EntityQuery<T> totalQuery = InMemorySearchUtils.buildSubQuery(query);
        for (Directory directory : this.directories) {
            SingleDirectorySearchStrategy singleSearch = new SingleDirectorySearchStrategy(this.directoryManager, directory.getId());
            results.addAll((Iterable)provider.apply(singleSearch, totalQuery));
        }
        return results.constrainResults();
    }

    protected <T> List<T> searchNonMerging(EntityQuery<T> query, BiFunction<SingleDirectorySearchStrategy, EntityQuery<T>, List<T>> provider) {
        Function cmp = InMemorySearchUtils.getMergingAggregatingAndSortingComparatorFor(query.getReturnType());
        Function cmpWithDirectoryOrder = p -> Pair.of((Object)cmp.apply(p.getLeft()), (Object)p.getRight());
        ResultsAggregator results = ResultsAggregators.with((Function)cmpWithDirectoryOrder, (int)query.getStartIndex(), (int)query.getMaxResults());
        EntityQuery<T> totalQuery = InMemorySearchUtils.buildSubQuery(query);
        int directoryIndex = 0;
        for (Directory directory : this.directories) {
            SingleDirectorySearchStrategy singleSearch = new SingleDirectorySearchStrategy(this.directoryManager, directory.getId());
            for (T entity : provider.apply(singleSearch, totalQuery)) {
                results.add((Object)Pair.of(entity, (Object)directoryIndex));
            }
            ++directoryIndex;
        }
        return results.constrainResults().stream().map(Pair::getLeft).collect(Collectors.toList());
    }
}

