/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.application;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.manager.application.AbstractInMemoryMembershipSearchStrategy;
import com.atlassian.crowd.manager.application.InMemorySearchUtils;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.search.query.QueryUtils;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.search.util.ResultsAggregator;
import com.atlassian.crowd.search.util.ResultsAggregators;
import java.util.List;

public class InMemoryAggregatingMembershipSearchStrategy
extends AbstractInMemoryMembershipSearchStrategy {
    public InMemoryAggregatingMembershipSearchStrategy(DirectoryManager directoryManager, List<Directory> directories) {
        super(directoryManager, directories);
    }

    @Override
    public <T> List<T> searchDirectGroupRelationships(MembershipQuery<T> query) {
        QueryUtils.checkAssignableFrom((Class)query.getReturnType(), (Class[])new Class[]{String.class, Group.class, User.class});
        ResultsAggregator results = ResultsAggregators.with(InMemorySearchUtils.getMergingAggregatingAndSortingComparatorFor(query.getReturnType()), query);
        for (Directory directory : this.directories) {
            results.addAll(this.doDirectDirectoryMembershipQuery(query, directory.getId()));
        }
        return results.constrainResults();
    }

    @Override
    public <T> List<T> searchNestedGroupRelationships(MembershipQuery<T> query) {
        QueryUtils.checkAssignableFrom((Class)query.getReturnType(), (Class[])new Class[]{String.class, Group.class, User.class});
        ResultsAggregator results = ResultsAggregators.with(InMemorySearchUtils.getMergingAggregatingAndSortingComparatorFor(query.getReturnType()), query);
        for (Directory directory : this.directories) {
            results.addAll(this.doNestedDirectoryMembershipQuery(query, directory.getId()));
        }
        return results.constrainResults();
    }
}

