/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.application;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.manager.application.GroupSearchStrategy;
import com.atlassian.crowd.manager.application.InMemoryAggregatingMembershipSearchStrategy;
import com.atlassian.crowd.manager.application.InMemoryEntitySearchStrategy;
import com.atlassian.crowd.manager.application.InMemoryNonAggregatingMembershipSearchStrategy;
import com.atlassian.crowd.manager.application.MembershipSearchStrategy;
import com.atlassian.crowd.manager.application.NoDirectorySearchStrategy;
import com.atlassian.crowd.manager.application.SearchStrategyFactory;
import com.atlassian.crowd.manager.application.SingleDirectorySearchStrategy;
import com.atlassian.crowd.manager.application.UserSearchStrategy;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;

public class DefaultSearchStrategyFactory
implements SearchStrategyFactory {
    private final DirectoryManager directoryManager;

    public DefaultSearchStrategyFactory(DirectoryManager directoryManager) {
        this.directoryManager = Objects.requireNonNull(directoryManager, "directoryManager");
    }

    @Override
    public MembershipSearchStrategy createMembershipSearchStrategy(boolean aggregateMemberships, List<Directory> directories) {
        if (directories.isEmpty()) {
            return NoDirectorySearchStrategy.INSTANCE;
        }
        if (directories.size() == 1) {
            return new SingleDirectorySearchStrategy(this.directoryManager, ((Directory)Iterables.getOnlyElement(directories)).getId());
        }
        return aggregateMemberships ? new InMemoryAggregatingMembershipSearchStrategy(this.directoryManager, directories) : new InMemoryNonAggregatingMembershipSearchStrategy(this.directoryManager, directories);
    }

    @Override
    public UserSearchStrategy createUserSearchStrategy(boolean mergeUsers, List<Directory> directories) {
        if (directories.isEmpty()) {
            return NoDirectorySearchStrategy.INSTANCE;
        }
        if (directories.size() == 1) {
            return new SingleDirectorySearchStrategy(this.directoryManager, ((Directory)Iterables.getOnlyElement(directories)).getId());
        }
        return new InMemoryEntitySearchStrategy(this.directoryManager, directories, mergeUsers);
    }

    @Override
    public GroupSearchStrategy createGroupSearchStrategy(boolean mergeGroups, List<Directory> directories) {
        if (directories.isEmpty()) {
            return NoDirectorySearchStrategy.INSTANCE;
        }
        if (directories.size() == 1) {
            return new SingleDirectorySearchStrategy(this.directoryManager, ((Directory)Iterables.getOnlyElement(directories)).getId());
        }
        return new InMemoryEntitySearchStrategy(this.directoryManager, directories, mergeGroups);
    }
}

