/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory;

import com.atlassian.crowd.attribute.AttributePredicates;
import com.atlassian.crowd.audit.AuditLogChangeset;
import com.atlassian.crowd.audit.AuditLogEntityType;
import com.atlassian.crowd.audit.AuditLogEventType;
import com.atlassian.crowd.audit.ImmutableAuditLogChangeset;
import com.atlassian.crowd.audit.ImmutableAuditLogEntity;
import com.atlassian.crowd.directory.AbstractForwardingDirectory;
import com.atlassian.crowd.directory.FastEntityCountProvider;
import com.atlassian.crowd.directory.InternalRemoteDirectory;
import com.atlassian.crowd.directory.MultiValuesQueriesSupport;
import com.atlassian.crowd.directory.RemoteCrowdDirectory;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.SynchronisableDirectory;
import com.atlassian.crowd.directory.SynchronisableDirectoryProperties;
import com.atlassian.crowd.directory.hybrid.LocalGroupHandler;
import com.atlassian.crowd.directory.ldap.cache.CacheRefresherFactory;
import com.atlassian.crowd.directory.ldap.cache.DirectoryCacheFactory;
import com.atlassian.crowd.directory.synchronisation.CacheSynchronisationResult;
import com.atlassian.crowd.directory.synchronisation.cache.CacheRefresher;
import com.atlassian.crowd.directory.synchronisation.cache.DirectoryCache;
import com.atlassian.crowd.embedded.api.Attributes;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.event.user.UserRenamedEvent;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.InvalidMembershipException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.MembershipAlreadyExistsException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.audit.AuditService;
import com.atlassian.crowd.manager.audit.mapper.AuditLogUserMapper;
import com.atlassian.crowd.manager.directory.SynchronisationMode;
import com.atlassian.crowd.manager.directory.SynchronisationStatusManager;
import com.atlassian.crowd.model.directory.SynchronisationStatusKey;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.crowd.model.group.InternalDirectoryGroup;
import com.atlassian.crowd.model.user.InternalUser;
import com.atlassian.crowd.model.user.TimestampedUser;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithAttributes;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.util.TimedOperation;
import com.atlassian.event.api.EventPublisher;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbCachingRemoteDirectory
extends AbstractForwardingDirectory
implements RemoteDirectory,
SynchronisableDirectory,
FastEntityCountProvider,
MultiValuesQueriesSupport {
    private static final Logger log = LoggerFactory.getLogger(DbCachingRemoteDirectory.class);
    public static final String INTERNAL_USER_PASSWORD = "nopass";
    private final RemoteDirectory remoteDirectory;
    private final LocalGroupHandler localGroupHandler;
    private final InternalRemoteDirectory internalDirectory;
    private final DirectoryCacheFactory directoryCacheFactory;
    private final CacheRefresherFactory cacheRefresherFactory;
    private final AuditService auditService;
    private final String directoryName;
    private final AuditLogUserMapper auditLogUserMapper;
    private final EventPublisher eventPublisher;
    private final DirectoryDao directoryDao;

    public DbCachingRemoteDirectory(RemoteDirectory remoteDirectory, InternalRemoteDirectory internalDirectory, DirectoryCacheFactory directoryCacheFactory, CacheRefresherFactory cacheRefresherFactory, AuditService auditService, AuditLogUserMapper auditLogUserMapper, String directoryName, EventPublisher eventPublisher, DirectoryDao directoryDao) {
        this(remoteDirectory, internalDirectory, directoryCacheFactory, new LocalGroupHandler(internalDirectory), cacheRefresherFactory, auditService, auditLogUserMapper, directoryName, eventPublisher, directoryDao);
    }

    private DbCachingRemoteDirectory(RemoteDirectory remoteDirectory, InternalRemoteDirectory internalDirectory, DirectoryCacheFactory directoryCacheFactory, LocalGroupHandler localGroupHandler, CacheRefresherFactory cacheRefresherFactory, AuditService auditService, AuditLogUserMapper auditLogUserMapper, String directoryName, EventPublisher eventPublisher, DirectoryDao directoryDao) {
        this.remoteDirectory = remoteDirectory;
        this.internalDirectory = internalDirectory;
        this.directoryCacheFactory = directoryCacheFactory;
        this.localGroupHandler = localGroupHandler;
        this.cacheRefresherFactory = cacheRefresherFactory;
        this.auditService = auditService;
        this.directoryName = directoryName;
        this.auditLogUserMapper = auditLogUserMapper;
        this.eventPublisher = eventPublisher;
        this.directoryDao = directoryDao;
    }

    public long getDirectoryId() {
        return this.remoteDirectory.getDirectoryId();
    }

    public void setDirectoryId(long directoryId) {
        throw new UnsupportedOperationException("You cannot mutate the directoryID of " + ((Object)((Object)this)).getClass().getName());
    }

    public String getDescriptiveName() {
        return this.remoteDirectory.getDescriptiveName();
    }

    public void setAttributes(Map<String, String> attributes) {
        throw new UnsupportedOperationException("You cannot mutate the attributes of " + ((Object)((Object)this)).getClass().getName());
    }

    public User authenticate(String name, PasswordCredential credential) throws UserNotFoundException, InactiveAccountException, InvalidAuthenticationException, ExpiredCredentialException, OperationFailedException {
        if (this.remoteDirectory instanceof RemoteCrowdDirectory) {
            return this.authenticateAndUpdateInternalUser(name, credential);
        }
        return this.performAuthenticationAndUpdateAttributes(name, credential);
    }

    private User performAuthenticationAndUpdateAttributes(String name, PasswordCredential credential) throws UserNotFoundException, ExpiredCredentialException, InactiveAccountException, OperationFailedException, InvalidAuthenticationException {
        HashMap<String, Set<String>> attributesToUpdate = new HashMap<String, Set<String>>();
        try {
            TimestampedUser internalUser;
            User authenticatedUser = this.authenticateAndUpdateInternalUser(name, credential);
            if (!this.remoteDirectory.supportsInactiveAccounts() && !(internalUser = this.internalDirectory.findUserByName(name)).isActive()) {
                throw new InactiveAccountException(name);
            }
            attributesToUpdate.put("invalidPasswordAttempts", Collections.singleton(Long.toString(0L)));
            attributesToUpdate.put("lastAuthenticated", Collections.singleton(Long.toString(System.currentTimeMillis())));
            this.storeUserAttributes(name, attributesToUpdate);
            return authenticatedUser;
        }
        catch (InvalidAuthenticationException e) {
            UserWithAttributes user = this.findUserWithAttributesByName(name);
            long currentInvalidAttempts = NumberUtils.toLong((String)user.getValue("invalidPasswordAttempts"), (long)0L);
            attributesToUpdate.put("invalidPasswordAttempts", Collections.singleton(Long.toString(++currentInvalidAttempts)));
            this.storeUserAttributes(name, attributesToUpdate);
            throw e;
        }
    }

    @VisibleForTesting
    protected User authenticateAndUpdateInternalUser(String name, PasswordCredential credential) throws UserNotFoundException, InactiveAccountException, InvalidAuthenticationException, ExpiredCredentialException, OperationFailedException {
        User remoteUser = this.remoteDirectory.authenticate(name, credential);
        this.updateUserFromRemoteDirectory(remoteUser);
        return remoteUser;
    }

    public User updateUserFromRemoteDirectory(@Nonnull User remoteUser) throws OperationFailedException, UserNotFoundException {
        TimestampedUser internalUser = this.findLocalUserByExternalIdOrName(remoteUser);
        boolean internalUserNotSynchronizedYet = internalUser == null;
        try {
            if (internalUserNotSynchronizedYet) {
                internalUser = this.addInternalUser((UserWithAttributes)UserTemplateWithAttributes.toUserWithNoAttributes((User)remoteUser));
            } else {
                String oldUsername = internalUser.getName();
                if (!oldUsername.equals(remoteUser.getName())) {
                    internalUser = this.internalDirectory.forceRenameUser((User)internalUser, remoteUser.getName());
                    Directory directory = this.directoryDao.findById(remoteUser.getDirectoryId());
                    this.eventPublisher.publish((Object)new UserRenamedEvent((Object)this, directory, (User)internalUser, oldUsername));
                }
                internalUser = this.updateUserAndSetActiveFlag(remoteUser, (User)internalUser);
            }
        }
        catch (InvalidUserException ex) {
            throw new OperationFailedException((Throwable)ex);
        }
        catch (DirectoryNotFoundException e) {
            throw new OperationFailedException("Invalid directory: directory " + remoteUser.getDirectoryId() + " not found", (Throwable)e);
        }
        if (this.shouldSyncGroupMembershipAfterUserAuthentication(internalUserNotSynchronizedYet)) {
            this.updateGroupsMembershipOnLogin(remoteUser);
        }
        return internalUser;
    }

    public User userAuthenticated(String username) throws OperationFailedException, UserNotFoundException, InactiveAccountException {
        User authenticated = super.userAuthenticated(username);
        if (!(this.getAuthoritativeDirectory() instanceof RemoteCrowdDirectory)) {
            this.storeUserAttributes(authenticated.getName(), Collections.singletonMap("lastAuthenticated", Collections.singleton(Long.toString(System.currentTimeMillis()))));
        }
        return authenticated;
    }

    private TimestampedUser findLocalUserByExternalIdOrName(User remoteUser) {
        TimestampedUser user = this.findLocalUserByExternalId(remoteUser.getExternalId());
        if (user != null) {
            return user;
        }
        try {
            return this.internalDirectory.findUserByName(remoteUser.getName());
        }
        catch (UserNotFoundException e) {
            return null;
        }
    }

    private TimestampedUser findLocalUserByExternalId(String externalId) {
        try {
            if (externalId != null && !externalId.isEmpty()) {
                return this.internalDirectory.findUserByExternalId(externalId);
            }
            return null;
        }
        catch (UserNotFoundException e) {
            return null;
        }
    }

    @VisibleForTesting
    protected User updateUserAndSetActiveFlag(User remoteUser, User internalUser) throws UserNotFoundException, InvalidUserException, OperationFailedException {
        this.preventExternalIdDuplication(remoteUser, internalUser);
        UserTemplate userTemplate = new UserTemplate(remoteUser);
        if (!this.remoteDirectory.supportsInactiveAccounts() || this.internalDirectory.isLocalUserStatusEnabled()) {
            userTemplate.setActive(internalUser.isActive());
        }
        return this.internalDirectory.updateUser(userTemplate);
    }

    @VisibleForTesting
    protected void updateGroupsMembershipOnLogin(User user) throws OperationFailedException, UserNotFoundException {
        log.debug("Updating groups on login for user {}", (Object)user.getName());
        MembershipQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(user.getName()).returningAtMost(-1);
        ImmutableSet userRemoteGroupNames = ImmutableSet.copyOf((Collection)this.remoteDirectory.searchGroupRelationships(query));
        ImmutableSet userLocalGroupNames = ImmutableSet.copyOf((Collection)this.internalDirectory.searchGroupRelationships(query));
        Sets.SetView groupsToAddUser = Sets.difference((Set)userRemoteGroupNames, (Set)userLocalGroupNames);
        Sets.SetView groupsToRemoveUser = Sets.difference((Set)userLocalGroupNames, (Set)userRemoteGroupNames);
        if (!groupsToRemoveUser.isEmpty() && !userRemoteGroupNames.isEmpty()) {
            ImmutableSet<String> localGroups = this.findAllLocalGroups();
            for (String groupName : groupsToRemoveUser) {
                try {
                    if (localGroups.contains((Object)groupName)) continue;
                    this.internalDirectory.removeUserFromGroup(user.getName(), groupName);
                }
                catch (GroupNotFoundException e) {
                    log.debug("Group {} not found when trying to remove user {} from group during auth", (Object)groupName, (Object)user.getName());
                }
                catch (ReadOnlyGroupException e) {
                    throw new RuntimeException("Failed to remove user from internal directory as group " + groupName + " is read only ", e);
                }
                catch (MembershipNotFoundException e) {
                    log.debug("User " + user.getName() + " is no longer member of the group " + groupName);
                }
            }
        }
        for (String groupName : groupsToAddUser) {
            try {
                try {
                    this.addUserToGroupInternal(user.getName(), groupName);
                }
                catch (GroupNotFoundException e) {
                    log.debug("Group {} doesn't exist during authentication of user {}, trying to create", (Object)groupName, (Object)user.getName());
                    if (!this.syncRemoteGroupToInternalDirectory(groupName)) continue;
                    this.addUserToGroupInternal(user.getName(), groupName);
                }
            }
            catch (GroupNotFoundException e) {
                throw new RuntimeException("Failed adding the user " + user.getName() + " as group " + groupName + " doesn't exist", e);
            }
            catch (ReadOnlyGroupException e) {
                throw new RuntimeException("Failed to add user from internal directory as group " + groupName + " is read only ", e);
            }
        }
    }

    private boolean syncRemoteGroupToInternalDirectory(String groupName) throws OperationFailedException {
        block6: {
            GroupWithAttributes remoteGroup;
            try {
                remoteGroup = this.remoteDirectory.findGroupWithAttributesByName(groupName);
            }
            catch (GroupNotFoundException e) {
                log.debug("Tried to add group " + groupName + " to internal directory, but failed retrieving the group from remote. Ignoring.", (Throwable)e);
                return false;
            }
            try {
                GroupTemplate internalGroup = new GroupTemplate(remoteGroup.getName(), this.internalDirectory.getDirectoryId());
                internalGroup.setDescription(remoteGroup.getDescription());
                this.internalDirectory.addGroup(internalGroup);
                Map groupAttributes = remoteGroup.getKeys().stream().filter(AttributePredicates.SYNCING_ATTRIBUTE).collect(Collectors.toMap(Function.identity(), arg_0 -> ((GroupWithAttributes)remoteGroup).getValues(arg_0)));
                if (groupAttributes.isEmpty()) break block6;
                try {
                    this.internalDirectory.storeGroupAttributes(internalGroup.getName(), groupAttributes);
                }
                catch (GroupNotFoundException e) {
                    throw new OperationFailedException((Throwable)e);
                }
            }
            catch (InvalidGroupException ige) {
                log.debug("Failed to add group " + groupName, (Throwable)ige);
            }
        }
        return true;
    }

    private void preventExternalIdDuplication(User remoteUser, User internalUser) throws OperationFailedException, InvalidUserException {
        if (StringUtils.isBlank((CharSequence)remoteUser.getExternalId()) || remoteUser.getExternalId().equals(internalUser.getExternalId())) {
            return;
        }
        try {
            TimestampedUser internalUserByExternalId = this.internalDirectory.findUserByExternalId(remoteUser.getExternalId());
            if (internalUserByExternalId != null) {
                this.removeExternalId((User)internalUserByExternalId);
                log.warn("Possible user unique id duplication, removing unique id: " + internalUser.getExternalId() + " for user " + internalUser.getName());
            }
        }
        catch (UserNotFoundException userNotFoundException) {
            // empty catch block
        }
    }

    private void removeExternalId(User user) throws UserNotFoundException, InvalidUserException, OperationFailedException {
        UserTemplate userTemplate = new UserTemplate(user);
        userTemplate.setExternalId(null);
        this.internalDirectory.updateUser(userTemplate);
    }

    private ImmutableSet<String> findAllLocalGroups() throws OperationFailedException {
        if (!this.localGroupHandler.isLocalGroupsEnabled()) {
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf((Collection)this.internalDirectory.searchGroups(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.LOCAL).exactlyMatching((Object)true)).returningAtMost(-1)));
    }

    public UserWithAttributes addUser(UserTemplateWithAttributes user, PasswordCredential credential) throws InvalidUserException, InvalidCredentialException, UserAlreadyExistsException, OperationFailedException {
        UserTemplateWithAttributes userToBeAddedToTheRemoteServer = UserTemplateWithAttributes.toUserWithNoAttributes((User)user);
        if (this.isUserAttributeSynchronisationEnabled()) {
            user.getAttributes().entrySet().stream().filter(AttributePredicates.SYNCHRONISABLE_ATTRIBUTE_ENTRY_PREDICATE).forEach(syncAttrEntry -> userToBeAddedToTheRemoteServer.setAttribute((String)syncAttrEntry.getKey(), (Set)syncAttrEntry.getValue()));
        }
        UserWithAttributes remoteUser = this.remoteDirectory.addUser(userToBeAddedToTheRemoteServer, credential);
        UserTemplateWithAttributes userTemplateWithAttributes = new UserTemplateWithAttributes(remoteUser);
        for (String key : user.getKeys()) {
            if (remoteUser.getValue(key) != null) continue;
            userTemplateWithAttributes.setAttribute(key, user.getValues(key));
        }
        return this.addInternalUser((UserWithAttributes)userTemplateWithAttributes);
    }

    @VisibleForTesting
    boolean isUserAttributeSynchronisationEnabled() {
        return Boolean.parseBoolean(this.remoteDirectory.getValue("userAttributesSyncEnabled"));
    }

    private UserWithAttributes addInternalUser(UserWithAttributes user) throws InvalidUserException, OperationFailedException {
        try {
            return this.internalDirectory.addUser(new UserTemplateWithAttributes(user), PasswordCredential.encrypted((String)INTERNAL_USER_PASSWORD));
        }
        catch (InvalidCredentialException ex) {
            throw new RuntimeException("Unexpected Credential Exception", ex);
        }
        catch (UserAlreadyExistsException ex) {
            try {
                this.internalDirectory.updateUser((UserTemplate)new UserTemplateWithAttributes(user));
                return this.internalDirectory.findUserWithAttributesByName(user.getName());
            }
            catch (UserNotFoundException e) {
                throw new ConcurrentModificationException(e);
            }
        }
    }

    public User updateUser(UserTemplate user) throws InvalidUserException, UserNotFoundException, OperationFailedException {
        UserTemplate remoteUserTemplate = new UserTemplate((User)user);
        if (this.remoteDirectory.supportsInactiveAccounts() && this.isLocalUserStatusEnabled()) {
            User existingRemoteUser = this.remoteDirectory.findUserByName(user.getName());
            remoteUserTemplate.setActive(existingRemoteUser.isActive());
        }
        User updatedUser = this.remoteDirectory.updateUser(remoteUserTemplate);
        UserTemplate updatedUserTemplate = new UserTemplate(updatedUser);
        if (!this.remoteDirectory.supportsInactiveAccounts() || this.isLocalUserStatusEnabled()) {
            updatedUserTemplate.setActive(user.isActive());
        }
        return this.internalDirectory.updateUser(updatedUserTemplate);
    }

    private boolean isLocalUserStatusEnabled() {
        return this.internalDirectory.isLocalUserStatusEnabled();
    }

    public void updateUserCredential(String username, PasswordCredential credential) throws UserNotFoundException, InvalidCredentialException, OperationFailedException {
        this.remoteDirectory.updateUserCredential(username, credential);
        this.auditLogUpdateCredential(username);
    }

    private void auditLogUpdateCredential(String username) {
        if (this.auditService.shouldAuditEvent()) {
            ImmutableAuditLogEntity.Builder primaryUserEntityBuilder = new ImmutableAuditLogEntity.Builder().setPrimary().setEntityName(username).setEntityType(AuditLogEntityType.USER);
            try {
                InternalUser internalUser = (InternalUser)this.internalDirectory.findUserByName(username);
                primaryUserEntityBuilder.setEntityId(internalUser.getId());
            }
            catch (UserNotFoundException e) {
                log.debug("User {} doesn\u2019t exist in the cache for directory {} while credential update. Audit log entry will be incomplete", (Object)username, (Object)this.getDirectoryId());
            }
            ImmutableAuditLogEntity directoryEntity = new ImmutableAuditLogEntity.Builder().setEntityId(Long.valueOf(this.getDirectoryId())).setEntityName(this.directoryName).setEntityType(AuditLogEntityType.DIRECTORY).build();
            ImmutableAuditLogChangeset auditLogChangeset = new ImmutableAuditLogChangeset.Builder().setEventType(AuditLogEventType.PASSWORD_CHANGED).addEntity(primaryUserEntityBuilder.build()).addEntity(directoryEntity).addEntry(this.auditLogUserMapper.calculatePasswordDiff()).build();
            this.auditService.saveAudit((AuditLogChangeset)auditLogChangeset);
        }
    }

    public User renameUser(String oldName, String newName) throws UserNotFoundException, InvalidUserException, OperationFailedException, UserAlreadyExistsException {
        this.remoteDirectory.renameUser(oldName, newName);
        return this.internalDirectory.renameUser(oldName, newName);
    }

    public void storeUserAttributes(String username, Map<String, Set<String>> attributes) throws UserNotFoundException, OperationFailedException {
        Map<String, Set> attributesToSync;
        if (this.isUserAttributeSynchronisationEnabled() && !(attributesToSync = attributes.entrySet().stream().filter(AttributePredicates.SYNCHRONISABLE_ATTRIBUTE_ENTRY_PREDICATE).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).isEmpty()) {
            this.remoteDirectory.storeUserAttributes(username, attributesToSync);
        }
        this.internalDirectory.storeUserAttributes(username, attributes);
    }

    public void removeUserAttributes(String username, String attributeName) throws UserNotFoundException, OperationFailedException {
        if (this.isUserAttributeSynchronisationEnabled() && AttributePredicates.SYNCING_ATTRIBUTE.test(attributeName)) {
            this.remoteDirectory.removeUserAttributes(username, attributeName);
        }
        this.internalDirectory.removeUserAttributes(username, attributeName);
    }

    public void removeUser(String name) throws UserNotFoundException, OperationFailedException {
        try {
            this.remoteDirectory.removeUser(name);
        }
        catch (UserNotFoundException ex) {
            this.internalDirectory.removeUser(name);
            throw ex;
        }
        this.internalDirectory.removeUser(name);
    }

    public Group addGroup(GroupTemplate group) throws InvalidGroupException, OperationFailedException {
        Group addedGroup;
        if (this.localGroupHandler.isLocalGroupsEnabled()) {
            if (this.isRemoteGroup(group.getName())) {
                throw new InvalidGroupException((Group)group, "Group already exists in the Remote Directory");
            }
            try {
                return this.localGroupHandler.createLocalGroup(DbCachingRemoteDirectory.makeGroupTemplate((Group)group));
            }
            catch (DirectoryNotFoundException e) {
                throw new OperationFailedException((Throwable)e);
            }
        }
        try {
            addedGroup = this.remoteDirectory.addGroup(group);
        }
        catch (InvalidGroupException ige) {
            Group existingRemoteGroup;
            try {
                existingRemoteGroup = this.remoteDirectory.findGroupByName(group.getName());
            }
            catch (GroupNotFoundException gnfe) {
                throw ige;
            }
            this.internalDirectory.addGroup(new GroupTemplate(existingRemoteGroup));
            throw ige;
        }
        GroupTemplate templateForInternalGroup = new GroupTemplate(addedGroup);
        try {
            return this.internalDirectory.addGroup(templateForInternalGroup);
        }
        catch (InvalidGroupException ige) {
            try {
                return this.internalDirectory.updateGroup(templateForInternalGroup);
            }
            catch (GroupNotFoundException | ReadOnlyGroupException exceptionFromUpdateGroup) {
                throw new OperationFailedException((Throwable)ige);
            }
        }
    }

    public Group updateGroup(GroupTemplate group) throws InvalidGroupException, GroupNotFoundException, OperationFailedException, ReadOnlyGroupException {
        if (this.localGroupHandler.isLocalGroupsEnabled()) {
            if (this.isRemoteGroup(group.getName())) {
                throw new ReadOnlyGroupException(group.getName());
            }
            return this.localGroupHandler.updateLocalGroup(DbCachingRemoteDirectory.makeGroupTemplate((Group)group));
        }
        Group updatedGroup = this.remoteDirectory.updateGroup(group);
        return this.internalDirectory.updateGroup(new GroupTemplate(updatedGroup));
    }

    public Group renameGroup(String oldName, String newName) throws GroupNotFoundException, InvalidGroupException {
        throw new UnsupportedOperationException("Renaming groups is not supported");
    }

    public void storeGroupAttributes(String groupName, Map<String, Set<String>> attributes) throws GroupNotFoundException, OperationFailedException {
        Map<String, Set> attributesToSync = attributes.entrySet().stream().filter(AttributePredicates.SYNCHRONISABLE_ATTRIBUTE_ENTRY_PREDICATE).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (!attributesToSync.isEmpty()) {
            this.remoteDirectory.storeGroupAttributes(groupName, attributesToSync);
        }
        this.internalDirectory.storeGroupAttributes(groupName, attributes);
    }

    public void removeGroupAttributes(String groupName, String attributeName) throws GroupNotFoundException, OperationFailedException {
        if (AttributePredicates.SYNCING_ATTRIBUTE.test(attributeName)) {
            this.remoteDirectory.removeGroupAttributes(groupName, attributeName);
        }
        this.internalDirectory.removeGroupAttributes(groupName, attributeName);
    }

    public void removeGroup(String name) throws GroupNotFoundException, OperationFailedException, ReadOnlyGroupException {
        Validate.notEmpty((CharSequence)name, (String)"group name must not be empty", (Object[])new Object[0]);
        InternalDirectoryGroup internalGroup = this.internalDirectory.findGroupByName(name);
        if (internalGroup.isLocal()) {
            this.internalDirectory.removeGroup(name);
        } else {
            if (this.localGroupHandler.isLocalGroupsEnabled()) {
                throw new ReadOnlyGroupException(name);
            }
            this.removeRemoteGroup(name);
        }
    }

    private void removeRemoteGroup(String name) throws ReadOnlyGroupException, OperationFailedException, GroupNotFoundException {
        try {
            this.remoteDirectory.removeGroup(name);
        }
        catch (GroupNotFoundException e) {
            this.internalDirectory.removeGroup(name);
            throw e;
        }
        this.internalDirectory.removeGroup(name);
    }

    private boolean isRemoteGroup(String groupName) throws OperationFailedException {
        try {
            this.remoteDirectory.findGroupByName(groupName);
            return true;
        }
        catch (GroupNotFoundException e) {
            return false;
        }
    }

    public void addUserToGroup(String username, String groupName) throws GroupNotFoundException, UserNotFoundException, OperationFailedException, ReadOnlyGroupException, MembershipAlreadyExistsException {
        if (this.localGroupHandler.isLocalGroupsEnabled()) {
            if (this.isRemoteGroup(groupName)) {
                throw new ReadOnlyGroupException(groupName);
            }
            this.localGroupHandler.addUserToLocalGroup(username, groupName);
        } else {
            try {
                this.remoteDirectory.addUserToGroup(username, groupName);
            }
            catch (MembershipAlreadyExistsException e) {
                this.addUserToGroupInternal(username, groupName);
                throw e;
            }
            this.addUserToGroupInternal(username, groupName);
        }
    }

    private void addUserToGroupInternal(String username, String groupName) throws GroupNotFoundException, UserNotFoundException, ReadOnlyGroupException, OperationFailedException {
        try {
            this.internalDirectory.addUserToGroup(username, groupName);
        }
        catch (MembershipAlreadyExistsException e) {
            log.debug("User (" + username + ") is already a member of group (" + groupName + ").");
        }
    }

    public void addGroupToGroup(String childGroup, String parentGroup) throws GroupNotFoundException, InvalidMembershipException, OperationFailedException, ReadOnlyGroupException, MembershipAlreadyExistsException {
        if (this.localGroupHandler.isLocalGroupsEnabled()) {
            if (this.isRemoteGroup(parentGroup)) {
                throw new ReadOnlyGroupException(parentGroup);
            }
            this.addGroupToGroupInternal(childGroup, parentGroup);
        } else {
            try {
                this.remoteDirectory.addGroupToGroup(childGroup, parentGroup);
            }
            catch (MembershipAlreadyExistsException e) {
                this.addGroupToGroupInternal(childGroup, parentGroup);
                throw e;
            }
            this.addGroupToGroupInternal(childGroup, parentGroup);
        }
    }

    private void addGroupToGroupInternal(String childGroup, String parentGroup) throws GroupNotFoundException, InvalidMembershipException, ReadOnlyGroupException, OperationFailedException {
        try {
            this.internalDirectory.addGroupToGroup(childGroup, parentGroup);
        }
        catch (MembershipAlreadyExistsException e) {
            log.debug("Group (" + childGroup + ") is already a member of group (" + parentGroup + ").");
        }
    }

    public void removeUserFromGroup(String username, String groupName) throws GroupNotFoundException, UserNotFoundException, MembershipNotFoundException, OperationFailedException, ReadOnlyGroupException {
        if (this.localGroupHandler.isLocalGroupsEnabled()) {
            if (this.isRemoteGroup(groupName)) {
                throw new ReadOnlyGroupException(groupName);
            }
            this.localGroupHandler.removeUserFromLocalGroup(username, groupName);
        } else {
            try {
                this.remoteDirectory.removeUserFromGroup(username, groupName);
            }
            catch (GroupNotFoundException | MembershipNotFoundException | UserNotFoundException exceptionFromRemoteDirectory) {
                this.silentlyRemoveUserFromGroupInTheCache(username, groupName);
                throw exceptionFromRemoteDirectory;
            }
            this.internalDirectory.removeUserFromGroup(username, groupName);
        }
    }

    private void silentlyRemoveUserFromGroupInTheCache(String username, String groupName) {
        try {
            this.internalDirectory.removeUserFromGroup(username, groupName);
        }
        catch (ObjectNotFoundException | OperationFailedException | ReadOnlyGroupException e) {
            log.debug("Ignoring exception when removing user from group in cache", e);
        }
    }

    public void removeGroupFromGroup(String childGroup, String parentGroup) throws GroupNotFoundException, InvalidMembershipException, MembershipNotFoundException, OperationFailedException, ReadOnlyGroupException {
        if (this.localGroupHandler.isLocalGroupsEnabled()) {
            if (this.isRemoteGroup(parentGroup)) {
                throw new ReadOnlyGroupException(parentGroup);
            }
            this.internalDirectory.removeGroupFromGroup(childGroup, parentGroup);
        } else {
            try {
                this.remoteDirectory.removeGroupFromGroup(childGroup, parentGroup);
            }
            catch (GroupNotFoundException | MembershipNotFoundException exceptionFromRemoteDirectory) {
                this.silentlyRemoveGroupFromGroupInTheCache(childGroup, parentGroup);
                throw exceptionFromRemoteDirectory;
            }
            this.internalDirectory.removeGroupFromGroup(childGroup, parentGroup);
        }
    }

    private void silentlyRemoveGroupFromGroupInTheCache(String childGroup, String parentGroup) {
        try {
            this.internalDirectory.removeGroupFromGroup(childGroup, parentGroup);
        }
        catch (InvalidMembershipException | ObjectNotFoundException | OperationFailedException | ReadOnlyGroupException e) {
            log.debug("Ignoring exception when removing group from group in cache", e);
        }
    }

    public void testConnection() throws OperationFailedException {
        this.remoteDirectory.testConnection();
    }

    public boolean supportsInactiveAccounts() {
        return this.remoteDirectory.supportsInactiveAccounts() || this.internalDirectory.isLocalUserStatusEnabled();
    }

    public boolean supportsNestedGroups() {
        return this.remoteDirectory.supportsNestedGroups();
    }

    public boolean supportsPasswordExpiration() {
        return this.remoteDirectory.supportsPasswordExpiration();
    }

    public boolean supportsSettingEncryptedCredential() {
        return this.remoteDirectory.supportsSettingEncryptedCredential();
    }

    public boolean isRolesDisabled() {
        return true;
    }

    private boolean shouldSyncGroupMembershipAfterUserAuthentication(boolean isNewUser) {
        SynchronisableDirectoryProperties.SyncGroupMembershipsAfterAuth groupSyncMode = SynchronisableDirectoryProperties.SyncGroupMembershipsAfterAuth.forDirectory((Attributes)this.remoteDirectory);
        return groupSyncMode == SynchronisableDirectoryProperties.SyncGroupMembershipsAfterAuth.ALWAYS || groupSyncMode == SynchronisableDirectoryProperties.SyncGroupMembershipsAfterAuth.WHEN_AUTHENTICATION_CREATED_THE_USER && isNewUser;
    }

    public Set<String> getValues(String name) {
        return this.remoteDirectory.getValues(name);
    }

    public String getValue(String name) {
        return this.remoteDirectory.getValue(name);
    }

    public boolean isEmpty() {
        return this.remoteDirectory.isEmpty();
    }

    public Set<String> getKeys() {
        return this.remoteDirectory.getKeys();
    }

    public boolean isIncrementalSyncEnabled() {
        return Boolean.parseBoolean(this.remoteDirectory.getValue("crowd.sync.incremental.enabled"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchroniseCache(SynchronisationMode mode, SynchronisationStatusManager synchronisationStatusManager) throws OperationFailedException {
        block19: {
            String description;
            TimedOperation operation;
            long directoryId;
            block18: {
                String token;
                directoryId = this.getDirectoryId();
                SynchronisationMode synchronisedMode = null;
                CacheSynchronisationResult result = null;
                CacheRefresher cacheRefresher = this.cacheRefresherFactory.createRefresher(this.remoteDirectory);
                try {
                    token = Optional.ofNullable(synchronisationStatusManager.getDirectorySynchronisationInformation(directoryId).getLastRound()).map(info -> {
                        if (info.getStartTime() > Long.parseLong(Optional.ofNullable(this.getValue("configuration.change.timestamp")).orElse("0"))) {
                            return synchronisationStatusManager.getLastSynchronisationTokenForDirectory(directoryId);
                        }
                        return null;
                    }).orElse(null);
                    synchronisationStatusManager.clearSynchronisationTokenForDirectory(directoryId);
                }
                catch (DirectoryNotFoundException e) {
                    token = null;
                }
                operation = new TimedOperation();
                try {
                    DirectoryCache directoryCache = this.directoryCacheFactory.createDirectoryCache(this.remoteDirectory, this.internalDirectory);
                    if (mode == SynchronisationMode.INCREMENTAL && this.isIncrementalSyncEnabled() && token != null) {
                        log.info("{} synchronisation for directory [ {} ] starting", (Object)mode, (Object)directoryId);
                        synchronisationStatusManager.syncStatus(directoryId, SynchronisationStatusKey.INCREMENTAL, Collections.emptyList());
                        try {
                            log.info("Attempting {} synchronisation for directory [ {} ]", (Object)mode, (Object)directoryId);
                            result = cacheRefresher.synchroniseChanges(directoryCache, token);
                            if (result.isSuccess()) {
                                synchronisedMode = SynchronisationMode.INCREMENTAL;
                            } else {
                                log.info("Incremental synchronisation for directory [ {} ] was not completed, falling back to a full synchronisation", (Object)directoryId);
                            }
                        }
                        catch (OperationFailedException | RuntimeException e) {
                            log.error("Incremental synchronisation for directory [ {} ] was unexpectedly interrupted, falling back to a full synchronisation", (Object)directoryId, (Object)e);
                        }
                    }
                    if (synchronisedMode == null) {
                        log.info("{} synchronisation for directory [ {} ] starting", (Object)SynchronisationMode.FULL, (Object)directoryId);
                        synchronisationStatusManager.syncStatus(directoryId, SynchronisationStatusKey.FULL, Collections.emptyList());
                        result = cacheRefresher.synchroniseAll(directoryCache);
                        synchronisedMode = SynchronisationMode.FULL;
                    }
                    description = " synchronisation complete for directory [ " + directoryId + " ]";
                    if (synchronisedMode == null) break block18;
                }
                catch (Throwable throwable) {
                    String description2 = " synchronisation complete for directory [ " + directoryId + " ]";
                    if (synchronisedMode != null) {
                        log.info(operation.complete(synchronisedMode + description2));
                        if (synchronisedMode.equals((Object)SynchronisationMode.FULL)) {
                            synchronisationStatusManager.syncFinished(directoryId, SynchronisationStatusKey.SUCCESS_FULL, Collections.emptyList());
                        } else if (synchronisedMode.equals((Object)SynchronisationMode.INCREMENTAL)) {
                            synchronisationStatusManager.syncFinished(directoryId, SynchronisationStatusKey.SUCCESS_INCREMENTAL, Collections.emptyList());
                        }
                        synchronisationStatusManager.storeSynchronisationTokenForDirectory(directoryId, result.getSyncStatusToken());
                    } else {
                        log.info(operation.complete("failed" + description2));
                        synchronisationStatusManager.syncFinished(directoryId, SynchronisationStatusKey.FAILURE, Collections.emptyList());
                    }
                    throw throwable;
                }
                log.info(operation.complete(synchronisedMode + description));
                if (synchronisedMode.equals((Object)SynchronisationMode.FULL)) {
                    synchronisationStatusManager.syncFinished(directoryId, SynchronisationStatusKey.SUCCESS_FULL, Collections.emptyList());
                } else if (synchronisedMode.equals((Object)SynchronisationMode.INCREMENTAL)) {
                    synchronisationStatusManager.syncFinished(directoryId, SynchronisationStatusKey.SUCCESS_INCREMENTAL, Collections.emptyList());
                }
                synchronisationStatusManager.storeSynchronisationTokenForDirectory(directoryId, result.getSyncStatusToken());
                break block19;
            }
            log.info(operation.complete("failed" + description));
            synchronisationStatusManager.syncFinished(directoryId, SynchronisationStatusKey.FAILURE, Collections.emptyList());
        }
    }

    public RemoteDirectory getAuthoritativeDirectory() {
        return this.remoteDirectory;
    }

    public void expireAllPasswords() throws OperationFailedException {
        this.remoteDirectory.expireAllPasswords();
    }

    public long getUserCount() throws OperationFailedException {
        return this.internalDirectory.getUserCount();
    }

    public long getGroupCount() throws OperationFailedException {
        return this.internalDirectory.getGroupCount();
    }

    protected InternalRemoteDirectory getDelegate() {
        return this.internalDirectory;
    }

    private static GroupTemplate makeGroupTemplate(Group group) {
        GroupTemplate template = new GroupTemplate(group);
        template.setDescription(group.getDescription());
        return template;
    }

    public <T> ListMultimap<String, T> searchGroupRelationshipsGroupedByName(MembershipQuery<T> query) {
        return this.internalDirectory.searchGroupRelationshipsGroupedByName(query);
    }
}

