/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.application;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.manager.application.InMemoryAggregatingSearchStrategy;
import com.atlassian.crowd.manager.application.InMemoryNonAggregatingSearchStrategy;
import com.atlassian.crowd.manager.application.NoDirectorySearchStrategy;
import com.atlassian.crowd.manager.application.SearchStrategy;
import com.atlassian.crowd.manager.application.SearchStrategyFactory;
import com.atlassian.crowd.manager.application.SingleDirectorySearchStrategy;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.application.Application;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DefaultSearchStrategyFactory
implements SearchStrategyFactory {
    private final DirectoryManager directoryManager;

    public DefaultSearchStrategyFactory(DirectoryManager directoryManager) {
        this.directoryManager = Objects.requireNonNull(directoryManager, "directoryManager");
    }

    @Override
    public Optional<SearchStrategy> createSearchStrategy(Application application, List<Directory> activeDirectories) {
        SearchStrategy strategy = activeDirectories.isEmpty() ? NoDirectorySearchStrategy.INSTANCE : (activeDirectories.size() == 1 ? new SingleDirectorySearchStrategy(this.directoryManager, ((Directory)Iterables.getOnlyElement(activeDirectories)).getId()) : (application.isMembershipAggregationEnabled() ? new InMemoryAggregatingSearchStrategy(this.directoryManager, activeDirectories) : new InMemoryNonAggregatingSearchStrategy(this.directoryManager, activeDirectories)));
        return Optional.of(strategy);
    }
}

