/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.directory;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.crowd.embedded.api.DirectorySynchronisationRoundInformation;
import com.atlassian.crowd.event.application.ApplicationReadyEvent;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.DirectorySynchronisationUtils;
import com.atlassian.crowd.manager.directory.SynchronisationStatusManager;
import com.atlassian.crowd.model.directory.SynchronisationStatusKey;
import com.atlassian.crowd.service.cluster.ClusterService;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventListenerRegistrar;
import java.util.Collections;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchronisationStatusFinalizer {
    private static final Logger logger = LoggerFactory.getLogger(SynchronisationStatusFinalizer.class);
    private final SynchronisationStatusManager synchronisationStatusManager;
    private final EventListenerRegistrar eventListenerRegistrar;
    private final DirectoryManager directoryManager;
    private final ClusterService clusterService;
    private final ClusterLockService clusterLockService;

    public SynchronisationStatusFinalizer(SynchronisationStatusManager synchronisationStatusManager, EventListenerRegistrar eventListenerRegistrar, DirectoryManager directoryManager, ClusterService clusterService, ClusterLockService clusterLockService) {
        this.synchronisationStatusManager = synchronisationStatusManager;
        this.eventListenerRegistrar = eventListenerRegistrar;
        this.directoryManager = directoryManager;
        this.clusterService = clusterService;
        this.clusterLockService = clusterLockService;
    }

    @PostConstruct
    public void register() {
        this.eventListenerRegistrar.register((Object)this);
    }

    @PreDestroy
    public void unregister() {
        this.eventListenerRegistrar.unregister((Object)this);
    }

    @EventListener
    public void handleEvent(ApplicationReadyEvent applicationReadyEvent) {
        if (this.clusterService.isAvailable()) {
            logger.debug("Not updating synchronization status on startup in clustered configuration");
            return;
        }
        this.directoryManager.findAllDirectories().forEach(directory -> {
            ClusterLock directoryLock = this.clusterLockService.getLockForName(DirectorySynchronisationUtils.getLockName(directory.getId()));
            if (directoryLock.tryLock()) {
                try {
                    DirectorySynchronisationRoundInformation activeStatus = this.synchronisationStatusManager.getDirectorySynchronisationInformation(directory.getId().longValue()).getActiveRound();
                    if (activeStatus == null) return;
                    logger.info("Found not final synchronisation status for directory {}", (Object)directory.getId());
                    this.synchronisationStatusManager.syncFinished(directory.getId().longValue(), SynchronisationStatusKey.ABORTED, Collections.emptyList());
                    this.synchronisationStatusManager.clearSynchronisationTokenForDirectory(directory.getId().longValue());
                    logger.info("Fixed stale synchronisation status for directory {}", (Object)directory.getId());
                    return;
                }
                catch (DirectoryNotFoundException e) {
                    logger.warn("Couldn't check synchronisation status for directory {}", (Object)directory.getId(), (Object)e);
                    return;
                }
                catch (Exception e) {
                    logger.warn("Couldn't finish synchronisation status for directory {}", (Object)directory.getId(), (Object)e);
                    return;
                }
                finally {
                    directoryLock.unlock();
                }
            } else {
                logger.debug("Not checking directory {}, lock unavailable", (Object)directory.getId());
            }
        });
    }
}

