/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.audit;

import com.atlassian.crowd.audit.AuditLogChangeset;
import com.atlassian.crowd.audit.ImmutableAuditLogChangeset;
import com.atlassian.crowd.dao.audit.AuditDao;
import com.atlassian.crowd.event.audit.internal.AuditLogSearchEvent;
import com.atlassian.crowd.manager.audit.AuditLogConfiguration;
import com.atlassian.crowd.manager.audit.InternalAuditService;
import com.atlassian.crowd.manager.audit.RetentionPeriod;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.model.audit.AuditLogChangesetEntity;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.event.api.EventPublisher;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class AuditServiceImpl
implements InternalAuditService {
    private static final Logger log = LoggerFactory.getLogger(AuditServiceImpl.class);
    protected final AuditDao auditDao;
    protected final PropertyManager propertyManager;
    protected final Clock clock;
    private EventPublisher eventPublisher;
    protected final boolean IS_ENABLED = !Boolean.getBoolean("crowd.audit.log.disable");

    public AuditServiceImpl(AuditDao auditDao, PropertyManager propertyManager, Clock clock, EventPublisher eventPublisher) {
        this.auditDao = auditDao;
        this.propertyManager = propertyManager;
        this.clock = clock;
        this.eventPublisher = eventPublisher;
        if (!this.IS_ENABLED) {
            log.warn("Audit log is currently disabled. Auditable events will not be stored in the audit log. Please restart Crowd without the {} flag to re-enable the audit log.", (Object)"crowd.audit.log.disable");
        }
    }

    @Transactional
    public void saveAudit(AuditLogChangeset changeset) {
        if (this.isEnabled()) {
            ImmutableAuditLogChangeset changesetWithRefreshedTimestamp = new ImmutableAuditLogChangeset.Builder(changeset).setTimestamp(Long.valueOf(this.clock.millis())).setId(null).build();
            this.auditDao.add(new AuditLogChangesetEntity((AuditLogChangeset)changesetWithRefreshedTimestamp));
        }
    }

    @Transactional
    public List<AuditLogChangeset> searchAuditLog(EntityQuery<AuditLogChangeset> query) {
        List changesets = this.auditDao.search(query);
        this.eventPublisher.publish((Object)new AuditLogSearchEvent(query.getSearchRestriction()));
        return changesets.stream().map(ImmutableAuditLogChangeset.Builder::new).map(ImmutableAuditLogChangeset.Builder::build).collect(Collectors.toList());
    }

    public boolean isEnabled() {
        return this.IS_ENABLED;
    }

    @Override
    @Transactional
    public int removeStaleEntries() {
        RetentionPeriod retentionPeriod = this.getConfiguration().getRetentionPeriod();
        if (retentionPeriod != RetentionPeriod.UNLIMITED) {
            Instant nowMinusRetentionPeriod = Instant.now(this.clock).minus(Duration.of(((Period)retentionPeriod.get().get()).getMonths() * 30, ChronoUnit.DAYS));
            log.debug("Cleaning audit log entries older than {}", (Object)nowMinusRetentionPeriod.toString());
            int removedEntities = this.auditDao.removeChangesetsOlderThan(nowMinusRetentionPeriod.toEpochMilli());
            log.debug("Successfully cleaned {} audit log entries", (Object)removedEntities);
            return removedEntities;
        }
        log.debug("Didn't clean audit log entries because the retention period is unlimited");
        return 0;
    }

    @Override
    @Transactional
    public long getAuditLogSize() {
        return this.auditDao.getAuditLogSize();
    }

    public void saveConfiguration(AuditLogConfiguration auditLogConfiguration) {
        this.propertyManager.setAuditLogConfiguration(auditLogConfiguration);
    }

    public AuditLogConfiguration getConfiguration() {
        return this.propertyManager.getAuditLogConfiguration();
    }
}

