/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.recovery;

import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.event.EventStore;
import com.atlassian.crowd.manager.application.ApplicationServiceGeneric;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.permission.PermissionManager;
import com.atlassian.crowd.manager.recovery.RecoveryModeService;
import com.atlassian.crowd.manager.webhook.WebhookRegistry;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.event.api.EventPublisher;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;

public class RecoveryModeAwareApplicationService
extends ApplicationServiceGeneric {
    private final RecoveryModeService recoveryModeService;

    public RecoveryModeAwareApplicationService(DirectoryManager directoryManager, PermissionManager permissionManager, DirectoryInstanceLoader directoryInstanceLoader, EventPublisher eventPublisher, EventStore eventStore, WebhookRegistry webhookRegistry, RecoveryModeService recoveryModeService) {
        super(directoryManager, permissionManager, directoryInstanceLoader, eventPublisher, eventStore, webhookRegistry);
        this.recoveryModeService = (RecoveryModeService)Preconditions.checkNotNull((Object)recoveryModeService, (Object)"recoveryModeService");
    }

    @Override
    protected Collection<Directory> getActiveDirectories(Application application) {
        Collection<Directory> directories = super.getActiveDirectories(application);
        if (this.recoveryModeService.isRecoveryModeOn()) {
            return ImmutableList.builder().add((Object)this.recoveryModeService.getRecoveryDirectory()).addAll(directories).build();
        }
        return directories;
    }
}

