/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory;

import com.atlassian.crowd.directory.DirectoryCacheChangeOperations;
import com.atlassian.crowd.directory.ldap.cache.DirectoryCache;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.util.TimedOperation;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryCacheImplUsingChangeOperations
implements DirectoryCache {
    private static final Logger logger = LoggerFactory.getLogger(DirectoryCacheImplUsingChangeOperations.class);
    private final DirectoryCacheChangeOperations dc;

    public DirectoryCacheImplUsingChangeOperations(DirectoryCacheChangeOperations dc) {
        this.dc = dc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrUpdateCachedUsers(List<? extends User> remoteUsers, Date syncStartDate) throws OperationFailedException {
        TimedOperation addOrUpdateRemoteUsersOperation = new TimedOperation();
        try {
            Set<UserTemplate> usersToUpdate;
            Set<UserTemplateWithCredentialAndAttributes> usersToAdd;
            TimedOperation findingUsersToAddAndUpdateOperation = new TimedOperation();
            try {
                DirectoryCacheChangeOperations.AddUpdateSets<UserTemplateWithCredentialAndAttributes, UserTemplate> result = this.dc.getUsersToAddAndUpdate(remoteUsers, syncStartDate);
                usersToAdd = result.getToAddSet();
                usersToUpdate = result.getToUpdateSet();
            }
            finally {
                logger.info(findingUsersToAddAndUpdateOperation.complete("scanned and compared [ " + remoteUsers.size() + " ] users for update in DB cache"));
            }
            this.dc.addUsers(usersToAdd);
            this.dc.updateUsers(usersToUpdate);
        }
        finally {
            logger.info(addOrUpdateRemoteUsersOperation.complete("synchronised [ " + remoteUsers.size() + " ] users"));
        }
    }

    public void deleteCachedUsersByGuid(Set<String> guids) throws OperationFailedException {
        this.dc.deleteCachedUsersByGuid(guids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrUpdateCachedGroups(List<? extends Group> remoteGroups, Date syncStartDate) throws OperationFailedException {
        logger.info("scanning [ {} ] groups to add or update", (Object)remoteGroups.size());
        TimedOperation operation = new TimedOperation();
        try {
            DirectoryCacheChangeOperations.GroupsToAddUpdateReplace addUpdateReplace = this.dc.findGroupsToUpdate(remoteGroups, syncStartDate);
            logger.debug("replacing [ {} ] groups", (Object)addUpdateReplace.groupsToReplace.size());
            this.dc.removeGroups(addUpdateReplace.groupsToReplace.keySet());
            HashSet<GroupTemplate> allToAdd = new HashSet<GroupTemplate>();
            allToAdd.addAll(addUpdateReplace.groupsToAdd);
            allToAdd.addAll(addUpdateReplace.groupsToReplace.values());
            this.dc.addGroups(allToAdd);
            this.dc.updateGroups(addUpdateReplace.groupsToUpdate);
        }
        finally {
            logger.info(operation.complete("synchronized [ " + remoteGroups.size() + " ] groups"));
        }
    }

    public void deleteCachedGroupsNotIn(GroupType groupType, List<? extends Group> remoteGroups, Date syncStartDate) throws OperationFailedException {
        this.dc.deleteCachedGroupsNotIn(groupType, remoteGroups, syncStartDate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncUserMembersForGroup(Group group, Collection<String> remoteUsers) throws OperationFailedException {
        TimedOperation operation = new TimedOperation();
        try {
            if (this.dc.ignoreGroupOnSynchroniseMemberships(group)) {
                return;
            }
            DirectoryCacheChangeOperations.AddRemoveSets<String> addRemove = this.dc.findUserMembershipForGroupChanges(group, remoteUsers);
            logger.debug("adding [ " + addRemove.toAdd.size() + " ] users to group [ " + group.getName() + " ]");
            logger.debug("removing [ " + addRemove.toRemove.size() + " ] users from group [ " + group.getName() + " ]");
            this.dc.addUserMembershipsForGroup(group, addRemove.toAdd);
            this.dc.removeUserMembershipsForGroup(group, addRemove.toRemove);
        }
        finally {
            logger.debug(operation.complete("synchronised [ " + remoteUsers.size() + " ] user members for group [ " + group.getName() + " ]"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncGroupMembersForGroup(Group parentGroup, Collection<String> remoteGroups) throws OperationFailedException {
        if (this.dc.ignoreGroupOnSynchroniseMemberships(parentGroup)) {
            return;
        }
        TimedOperation operation = new TimedOperation();
        try {
            DirectoryCacheChangeOperations.AddRemoveSets<String> addRemove = this.dc.findGroupMembershipForGroupChanges(parentGroup, remoteGroups);
            logger.debug("adding [ " + addRemove.toAdd.size() + " ] group members from group [ " + parentGroup.getName() + " ]");
            logger.debug("removing [ " + addRemove.toRemove.size() + " ] group members to group [ " + parentGroup.getName() + " ]");
            this.dc.addGroupMembershipsForGroup(parentGroup, addRemove.toAdd);
            this.dc.removeGroupMembershipsForGroup(parentGroup, addRemove.toRemove);
        }
        finally {
            logger.debug(operation.complete("synchronised [ " + remoteGroups.size() + " ] group members for group [ " + parentGroup.getName() + " ]"));
        }
    }

    public void deleteCachedGroups(Set<String> groupnames) throws OperationFailedException {
        this.dc.deleteCachedGroups(groupnames);
    }

    public void deleteCachedUsersNotIn(List<? extends User> users, Date syncStartDate) throws OperationFailedException {
        this.dc.deleteCachedUsersNotIn(users, syncStartDate);
    }

    public void addOrUpdateCachedUser(User user) throws OperationFailedException {
        this.dc.addOrUpdateCachedUser(user);
    }

    public void deleteCachedUser(String username) throws OperationFailedException {
        this.dc.deleteCachedUser(username);
    }

    public void addOrUpdateCachedGroup(Group group) throws OperationFailedException {
        this.dc.addOrUpdateCachedGroup(group);
    }

    public void deleteCachedGroup(String groupName) throws OperationFailedException {
        this.dc.deleteCachedGroup(groupName);
    }

    public void addUserToGroup(String username, String groupName) throws OperationFailedException {
        this.dc.addUserToGroup(username, groupName);
    }

    public void removeUserFromGroup(String username, String groupName) throws OperationFailedException {
        this.dc.removeUserFromGroup(username, groupName);
    }

    public void addGroupToGroup(String childGroup, String parentGroup) throws OperationFailedException {
        this.dc.addGroupToGroup(childGroup, parentGroup);
    }

    public void removeGroupFromGroup(String childGroup, String parentGroup) throws OperationFailedException {
        this.dc.removeGroupFromGroup(childGroup, parentGroup);
    }

    public void syncGroupMembershipsForUser(String childUsername, Set<String> parentGroupNames) throws OperationFailedException {
        this.dc.syncGroupMembershipsForUser(childUsername, parentGroupNames);
    }

    public void syncGroupMembershipsAndMembersForGroup(String groupName, Set<String> parentGroupNames, Set<String> childGroupNames) throws OperationFailedException {
        this.dc.syncGroupMembershipsAndMembersForGroup(groupName, parentGroupNames, childGroupNames);
    }

    public Set<String> getAllUserGuids() throws OperationFailedException {
        return this.dc.getAllUserGuids();
    }

    public long getUserCount() throws OperationFailedException {
        return this.dc.getUserCount();
    }
}

