/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.directory;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.SynchronisableDirectory;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.event.directory.RemoteDirectorySynchronisedEvent;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectorySynchronisationUtils;
import com.atlassian.crowd.manager.directory.DirectorySynchroniser;
import com.atlassian.crowd.manager.directory.DirectorySynchroniserHelper;
import com.atlassian.crowd.manager.directory.SynchronisationMode;
import com.atlassian.crowd.manager.directory.SynchronisationStatusManager;
import com.atlassian.event.api.EventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class DirectorySynchroniserImpl
implements DirectorySynchroniser {
    private static final Logger log = LoggerFactory.getLogger(DirectorySynchroniser.class);
    private final ClusterLockService lockService;
    private final DirectorySynchroniserHelper directorySynchroniserHelper;
    private final SynchronisationStatusManager synchronisationStatusManager;
    private final EventPublisher eventPublisher;

    public DirectorySynchroniserImpl(ClusterLockService lockService, DirectorySynchroniserHelper directorySynchroniserHelper, SynchronisationStatusManager synchronisationStatusManager, EventPublisher eventPublisher) {
        this.lockService = lockService;
        this.directorySynchroniserHelper = directorySynchroniserHelper;
        this.synchronisationStatusManager = synchronisationStatusManager;
        this.eventPublisher = eventPublisher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(propagation=Propagation.NEVER)
    public void synchronise(SynchronisableDirectory remoteDirectory, SynchronisationMode mode) throws DirectoryNotFoundException, OperationFailedException {
        long directoryId = remoteDirectory.getDirectoryId();
        Directory directory = this.findDirectoryById(directoryId);
        if (!directory.isActive()) {
            log.debug("Request to synchronise directory [ {} ] in {} mode is returning silently because the directory is not active.", (Object)directoryId, (Object)mode);
            return;
        }
        log.debug("request to synchronise directory [ {} ] in {} mode", (Object)directoryId, (Object)mode);
        ClusterLock lock = this.lockService.getLockForName(DirectorySynchronisationUtils.getLockName(directoryId));
        if (lock.tryLock()) {
            try {
                this.directorySynchroniserHelper.updateSyncStartTime(remoteDirectory);
                this.synchronisationStatusManager.syncStarted(directory);
                try {
                    remoteDirectory.synchroniseCache(mode, this.synchronisationStatusManager);
                }
                finally {
                    this.directorySynchroniserHelper.updateSyncEndTime(remoteDirectory);
                    this.synchronisationStatusManager.syncFinished(directoryId);
                }
            }
            finally {
                lock.unlock();
            }
            this.eventPublisher.publish((Object)new RemoteDirectorySynchronisedEvent((Object)this, (RemoteDirectory)remoteDirectory));
        } else {
            log.debug("directory [ {} ] already synchronising", (Object)directoryId);
        }
    }

    @Override
    public boolean isSynchronising(long directoryId) throws DirectoryNotFoundException {
        return this.directorySynchroniserHelper.isSynchronising(directoryId);
    }

    private Directory findDirectoryById(long directoryId) throws DirectoryNotFoundException {
        return this.directorySynchroniserHelper.findDirectoryById(directoryId);
    }
}

