/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.directory.monitor.poller;

import com.atlassian.crowd.directory.monitor.poller.DirectoryPoller;
import com.atlassian.crowd.manager.directory.SynchronisationMode;
import com.atlassian.crowd.manager.directory.monitor.DirectoryMonitorRegistrationException;
import com.atlassian.crowd.manager.directory.monitor.DirectoryMonitorUnregistrationException;
import com.atlassian.crowd.manager.directory.monitor.poller.DirectoryPollerJobRunner;
import com.atlassian.crowd.manager.directory.monitor.poller.DirectoryPollerManager;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.status.JobDetails;
import com.google.common.collect.ImmutableMap;
import java.util.Date;
import java.util.Map;

public class AtlassianSchedulerDirectoryPollerManager
implements DirectoryPollerManager {
    private final SchedulerService schedulerService;

    public AtlassianSchedulerDirectoryPollerManager(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    @Override
    public void addPoller(DirectoryPoller poller) throws DirectoryMonitorRegistrationException {
        Date startDelay = new Date(this.getStartDelay());
        JobConfig config = JobConfig.forJobRunnerKey((JobRunnerKey)DirectoryPollerJobRunner.JOB_RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forInterval((long)(poller.getPollingInterval() * 1000L), (Date)startDelay)).withParameters((Map)ImmutableMap.builder().put((Object)"DIRECTORY_ID", (Object)poller.getDirectoryID()).build());
        try {
            this.schedulerService.scheduleJob(this.getJobId(poller), config);
        }
        catch (SchedulerServiceException e) {
            throw new DirectoryMonitorRegistrationException((Throwable)e);
        }
    }

    @Override
    public boolean hasPoller(long directoryID) {
        return this.schedulerService.getJobDetails(this.getJobId(directoryID)) != null;
    }

    @Override
    public void triggerPoll(long directoryID, SynchronisationMode syncMode) {
        JobConfig config = JobConfig.forJobRunnerKey((JobRunnerKey)DirectoryPollerJobRunner.JOB_RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.runOnce(null)).withParameters((Map)ImmutableMap.builder().put((Object)"DIRECTORY_ID", (Object)directoryID).put((Object)"SYNC_MODE", (Object)syncMode).build());
        try {
            this.schedulerService.scheduleJob(this.getJobId(directoryID), config);
        }
        catch (SchedulerServiceException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean removePoller(long directoryID) throws DirectoryMonitorUnregistrationException {
        boolean exists = this.hasPoller(directoryID);
        this.schedulerService.unscheduleJob(this.getJobId(directoryID));
        return exists;
    }

    @Override
    public void removeAllPollers() {
        for (JobDetails job : this.schedulerService.getJobsByJobRunnerKey(DirectoryPollerJobRunner.JOB_RUNNER_KEY)) {
            this.schedulerService.unscheduleJob(job.getJobId());
        }
    }

    protected long getStartDelay() {
        return System.currentTimeMillis() + Long.getLong("crowd.polling.startdelay", 5000L);
    }

    private JobId getJobId(DirectoryPoller poller) {
        return this.getJobId(poller.getDirectoryID());
    }

    private JobId getJobId(long directoryId) {
        return JobId.of((String)(DirectoryPollerManager.class.getName() + "." + directoryId));
    }
}

