/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.directory;

import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.model.DirectoryEntity;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.search.util.SearchResultsUtil;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

class RemoteDirectorySearcher {
    private final RemoteDirectory remoteDirectory;

    RemoteDirectorySearcher(@Nonnull RemoteDirectory remoteDirectory) {
        this.remoteDirectory = (RemoteDirectory)Preconditions.checkNotNull((Object)remoteDirectory, (Object)"remoteDirectory");
    }

    boolean isUserDirectGroupMember(String userName, String groupName) throws OperationFailedException {
        return this.remoteDirectory.isUserDirectGroupMember(userName, groupName);
    }

    boolean isGroupDirectGroupMember(String childGroup, String parentGroup) throws OperationFailedException, DirectoryNotFoundException {
        return !childGroup.equals(parentGroup) && this.remoteDirectory.supportsNestedGroups() && this.remoteDirectory.isGroupDirectGroupMember(childGroup, parentGroup);
    }

    <T> List<T> searchDirectGroupRelationships(MembershipQuery<T> query) throws OperationFailedException, DirectoryNotFoundException {
        if (RemoteDirectorySearcher.isNestedGroupQuery(query) && !this.remoteDirectory.supportsNestedGroups()) {
            return Collections.emptyList();
        }
        if (RemoteDirectorySearcher.isLegacyQuery(query)) {
            return Collections.emptyList();
        }
        return this.remoteDirectory.searchGroupRelationships(query);
    }

    private static <T> boolean isNestedGroupQuery(MembershipQuery<T> query) {
        return query.getEntityToMatch().getEntityType() == Entity.GROUP && query.getEntityToReturn().getEntityType() == Entity.GROUP;
    }

    private static <T> boolean isLegacyQuery(MembershipQuery<T> query) {
        return RemoteDirectorySearcher.isLegacyRole(query.getEntityToMatch()) || RemoteDirectorySearcher.isLegacyRole(query.getEntityToReturn());
    }

    private static boolean isLegacyRole(EntityDescriptor entity) {
        return entity.getEntityType() == Entity.GROUP && entity.getGroupType() == GroupType.LEGACY_ROLE;
    }

    boolean isUserNestedGroupMember(String username, String groupName) throws OperationFailedException, DirectoryNotFoundException {
        if (this.remoteDirectory.supportsNestedGroups()) {
            return this.isUserNestedGroupMember(username, groupName, new HashSet<String>(64));
        }
        return this.isUserDirectGroupMember(username, groupName);
    }

    private boolean isUserNestedGroupMember(String username, String groupName, Set<String> visitedGroups) throws OperationFailedException, DirectoryNotFoundException {
        if (!visitedGroups.add(IdentifierUtils.toLowerCase((String)groupName))) {
            return false;
        }
        return this.remoteDirectory.isUserDirectGroupMember(username, groupName) || this.isUserIndirectGroupMember(username, groupName, visitedGroups);
    }

    private boolean isUserIndirectGroupMember(String username, String groupName, Set<String> visitedGroups) throws OperationFailedException, DirectoryNotFoundException {
        List subGroups = this.searchDirectGroupRelationships(QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(groupName).returningAtMost(-1));
        for (Group childGroup : subGroups) {
            if (!this.isUserNestedGroupMember(username, childGroup.getName(), visitedGroups)) continue;
            return true;
        }
        return false;
    }

    boolean isGroupNestedGroupMember(String childGroup, String parentGroup) throws OperationFailedException, DirectoryNotFoundException {
        return !childGroup.equals(parentGroup) && this.remoteDirectory.supportsNestedGroups() && this.isGroupNestedGroupMember(childGroup, parentGroup, new HashSet<String>(64));
    }

    private boolean isGroupNestedGroupMember(String childGroupName, String parentGroupName, Set<String> visitedGroups) throws OperationFailedException, DirectoryNotFoundException {
        if (!visitedGroups.add(IdentifierUtils.toLowerCase((String)parentGroupName))) {
            return false;
        }
        return this.remoteDirectory.isGroupDirectGroupMember(childGroupName, parentGroupName) || this.isGroupIndirectGroupMember(childGroupName, parentGroupName, visitedGroups);
    }

    private boolean isGroupIndirectGroupMember(String childGroupName, String parentGroupName, Set<String> visitedGroups) throws OperationFailedException, DirectoryNotFoundException {
        List subGroups = this.searchDirectGroupRelationships(QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(parentGroupName).returningAtMost(-1));
        for (Group childGroup : subGroups) {
            if (!this.isGroupNestedGroupMember(childGroupName, childGroup.getName(), visitedGroups)) continue;
            return true;
        }
        return false;
    }

    <T> List<T> searchNestedGroupRelationships(MembershipQuery<T> query) throws OperationFailedException, DirectoryNotFoundException {
        if (!this.remoteDirectory.supportsNestedGroups()) {
            return this.searchDirectGroupRelationships(query);
        }
        List relations = this.getRelatedDirectoryEntities(query);
        relations = SearchResultsUtil.constrainResults(relations, (int)query.getStartIndex(), (int)query.getMaxResults());
        if (query.getReturnType() == String.class) {
            return SearchResultsUtil.convertEntitiesToNames((Iterable)relations);
        }
        return relations;
    }

    private <T> List<? extends DirectoryEntity> getRelatedDirectoryEntities(MembershipQuery<T> query) throws OperationFailedException, DirectoryNotFoundException {
        int totalResults = query.getStartIndex() + query.getMaxResults();
        if (query.getMaxResults() == -1) {
            totalResults = -1;
        }
        if (query.isFindChildren()) {
            return this.getChildDirectoryEntities(query, totalResults);
        }
        return this.getParentDirectoryEntities(query, totalResults);
    }

    private <T> List<? extends DirectoryEntity> getParentDirectoryEntities(MembershipQuery<T> query, int totalResults) throws OperationFailedException, DirectoryNotFoundException {
        if (query.getEntityToReturn().getEntityType() != Entity.GROUP) {
            throw new IllegalArgumentException("You can only find the GROUP memberships of USER or GROUP");
        }
        if (query.getEntityToMatch().getEntityType() == Entity.USER) {
            return this.findNestedGroupMembershipsOfUser(query.getEntityNameToMatch(), query.getEntityToReturn().getGroupType(), totalResults);
        }
        if (query.getEntityToMatch().getEntityType() == Entity.GROUP) {
            return this.findNestedGroupMembershipsOfGroup(query.getEntityNameToMatch(), query.getEntityToReturn().getGroupType(), totalResults);
        }
        throw new IllegalArgumentException("You can only find the GROUP memberships of USER or GROUP");
    }

    private <T> List<? extends DirectoryEntity> getChildDirectoryEntities(MembershipQuery<T> query, int totalResults) throws OperationFailedException, DirectoryNotFoundException {
        if (query.getEntityToMatch().getEntityType() != Entity.GROUP) {
            throw new IllegalArgumentException("You can only find the GROUP or USER members of a GROUP");
        }
        if (query.getEntityToReturn().getEntityType() == Entity.USER) {
            return this.findNestedUserMembersOfGroup(query.getEntityNameToMatch(), query.getEntityToMatch().getGroupType(), totalResults);
        }
        if (query.getEntityToReturn().getEntityType() == Entity.GROUP) {
            return this.findNestedGroupMembersOfGroup(query.getEntityNameToMatch(), query.getEntityToMatch().getGroupType(), totalResults);
        }
        throw new IllegalArgumentException("You can only find the GROUP or USER members of a GROUP");
    }

    private List<Group> findNestedGroupMembershipsOfGroup(String groupName, GroupType groupType, int maxResults) throws OperationFailedException, DirectoryNotFoundException {
        Group group;
        try {
            group = this.remoteDirectory.findGroupByName(groupName);
        }
        catch (GroupNotFoundException e) {
            return Collections.emptyList();
        }
        return this.findNestedGroupMembershipsIncludingGroups(Arrays.asList(group), groupType, maxResults, false);
    }

    private List<Group> findNestedGroupMembershipsIncludingGroups(List<Group> groups, GroupType groupType, int maxResults, boolean includeOriginal) throws OperationFailedException, DirectoryNotFoundException {
        LinkedList<Object> groupsToVisit = new LinkedList<Object>();
        LinkedHashSet<Group> nestedParents = new LinkedHashSet<Group>();
        groupsToVisit.addAll(groups);
        int totalResults = maxResults;
        if (maxResults != -1 && !includeOriginal) {
            totalResults = maxResults + groups.size();
        }
        while (!(groupsToVisit.isEmpty() || totalResults != -1 && nestedParents.size() >= totalResults)) {
            Group groupToVisit = (Group)groupsToVisit.remove();
            if (nestedParents.contains(groupToVisit)) continue;
            nestedParents.add(groupToVisit);
            List directParents = this.searchDirectGroupRelationships(QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group((GroupType)groupType)).parentsOf(EntityDescriptor.group((GroupType)groupType)).withName(groupToVisit.getName()).returningAtMost(maxResults));
            groupsToVisit.addAll(directParents);
        }
        if (!includeOriginal) {
            nestedParents.removeAll(groups);
        }
        return new ArrayList<Group>(nestedParents);
    }

    private List<Group> findNestedGroupMembershipsOfUser(String username, GroupType groupType, int maxResults) throws OperationFailedException, DirectoryNotFoundException {
        List<Group> directGroupMemberships = this.searchDirectGroupRelationships(QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group((GroupType)groupType)).parentsOf(EntityDescriptor.user()).withName(username).returningAtMost(maxResults));
        return this.findNestedGroupMembershipsIncludingGroups(directGroupMemberships, groupType, maxResults, true);
    }

    private List<Group> findNestedGroupMembersOfGroup(String groupName, GroupType groupType, int maxResults) throws OperationFailedException, DirectoryNotFoundException {
        Group group;
        try {
            group = this.remoteDirectory.findGroupByName(groupName);
        }
        catch (GroupNotFoundException e) {
            return Collections.emptyList();
        }
        LinkedList<Object> groupsToVisit = new LinkedList<Object>();
        LinkedHashSet<Group> nestedMembers = new LinkedHashSet<Group>();
        groupsToVisit.add(group);
        while (!(groupsToVisit.isEmpty() || maxResults != -1 && nestedMembers.size() >= maxResults + 1)) {
            Group groupToVisit = (Group)groupsToVisit.remove();
            if (nestedMembers.contains(groupToVisit)) continue;
            nestedMembers.add(groupToVisit);
            List directMembers = this.searchDirectGroupRelationships(QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group((GroupType)groupType)).childrenOf(EntityDescriptor.group((GroupType)groupType)).withName(groupToVisit.getName()).returningAtMost(maxResults));
            groupsToVisit.addAll(directMembers);
        }
        nestedMembers.remove(group);
        return new ArrayList<Group>(nestedMembers);
    }

    private List<User> findNestedUserMembersOfGroup(String groupName, GroupType groupType, int maxResults) throws OperationFailedException, DirectoryNotFoundException {
        Group group;
        try {
            group = this.remoteDirectory.findGroupByName(groupName);
        }
        catch (GroupNotFoundException e) {
            return Collections.emptyList();
        }
        LinkedList<Object> groupsToVisit = new LinkedList<Object>();
        LinkedHashSet<Group> nestedGroupMembers = new LinkedHashSet<Group>();
        LinkedHashSet nestedUserMembers = new LinkedHashSet();
        groupsToVisit.add(group);
        while (!(groupsToVisit.isEmpty() || maxResults != -1 && nestedUserMembers.size() >= maxResults)) {
            Group groupToVisit = (Group)groupsToVisit.remove();
            List directUserMembers = this.searchDirectGroupRelationships(QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group((GroupType)groupType)).withName(groupToVisit.getName()).returningAtMost(maxResults));
            nestedUserMembers.addAll(directUserMembers);
            if (nestedGroupMembers.contains(groupToVisit)) continue;
            nestedGroupMembers.add(groupToVisit);
            List directGroupMembers = this.searchDirectGroupRelationships(QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group((GroupType)groupType)).childrenOf(EntityDescriptor.group((GroupType)groupType)).withName(groupToVisit.getName()).returningAtMost(-1));
            groupsToVisit.addAll(directGroupMembers);
        }
        return new ArrayList<User>(nestedUserMembers);
    }
}

