/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.directory;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.crowd.dao.application.ApplicationDAO;
import com.atlassian.crowd.dao.permission.InternalUserPermissionDAO;
import com.atlassian.crowd.directory.InternalRemoteDirectory;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.SynchronisableDirectory;
import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectorySynchronisationInformation;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.event.directory.DirectoryCreatedEvent;
import com.atlassian.crowd.event.directory.DirectoryDeletedEvent;
import com.atlassian.crowd.event.directory.DirectoryUpdatedEvent;
import com.atlassian.crowd.event.group.GroupAttributeDeletedEvent;
import com.atlassian.crowd.event.group.GroupAttributeStoredEvent;
import com.atlassian.crowd.event.group.GroupCreatedEvent;
import com.atlassian.crowd.event.group.GroupDeletedEvent;
import com.atlassian.crowd.event.group.GroupMembershipCreatedEvent;
import com.atlassian.crowd.event.group.GroupMembershipDeletedEvent;
import com.atlassian.crowd.event.group.GroupUpdatedEvent;
import com.atlassian.crowd.event.user.UserAttributeDeletedEvent;
import com.atlassian.crowd.event.user.UserAttributeStoredEvent;
import com.atlassian.crowd.event.user.UserCreatedEvent;
import com.atlassian.crowd.event.user.UserCredentialUpdatedEvent;
import com.atlassian.crowd.event.user.UserCredentialValidationFailed;
import com.atlassian.crowd.event.user.UserDeletedEvent;
import com.atlassian.crowd.event.user.UserEditedEvent;
import com.atlassian.crowd.event.user.UserRenamedEvent;
import com.atlassian.crowd.exception.DirectoryCurrentlySynchronisingException;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.InvalidMembershipException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.MembershipAlreadyExistsException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.NestedGroupsNotSupportedException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.BulkAddResult;
import com.atlassian.crowd.manager.directory.BulkRemoveResult;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.manager.directory.DirectorySynchronisationUtils;
import com.atlassian.crowd.manager.directory.DirectorySynchroniser;
import com.atlassian.crowd.manager.directory.SynchronisationMode;
import com.atlassian.crowd.manager.directory.SynchronisationStatusManager;
import com.atlassian.crowd.manager.directory.monitor.poller.DirectoryPollerManager;
import com.atlassian.crowd.manager.permission.PermissionManager;
import com.atlassian.crowd.model.DirectoryEntity;
import com.atlassian.crowd.model.NameComparator;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.crowd.model.membership.MembershipType;
import com.atlassian.crowd.model.permission.InternalGrantedPermission;
import com.atlassian.crowd.model.user.ImmutableUser;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.search.util.SearchResultsUtil;
import com.atlassian.crowd.util.BatchResult;
import com.atlassian.crowd.util.BoundedCount;
import com.atlassian.crowd.util.DirectoryEntityUtils;
import com.atlassian.event.api.EventPublisher;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class DirectoryManagerGeneric
implements DirectoryManager {
    private static final Logger logger = LoggerFactory.getLogger(DirectoryManagerGeneric.class);
    private final DirectoryDao directoryDao;
    private final ApplicationDAO applicationDAO;
    private final EventPublisher eventPublisher;
    private final PermissionManager permissionManager;
    private final DirectoryInstanceLoader directoryInstanceLoader;
    private final DirectorySynchroniser directorySynchroniser;
    private final DirectoryPollerManager directoryPollerManager;
    private final ClusterLockService lockService;
    private final SynchronisationStatusManager synchronisationStatusManager;
    private final InternalUserPermissionDAO userPermissionDAO;

    public DirectoryManagerGeneric(DirectoryDao directoryDao, ApplicationDAO applicationDAO, EventPublisher eventPublisher, PermissionManager permissionManager, DirectoryInstanceLoader directoryInstanceLoader, DirectorySynchroniser directorySynchroniser, DirectoryPollerManager directoryPollerManager, ClusterLockService lockService, SynchronisationStatusManager synchronisationStatusManager, InternalUserPermissionDAO userPermissionDAO) {
        this.directoryDao = (DirectoryDao)Preconditions.checkNotNull((Object)directoryDao);
        this.applicationDAO = (ApplicationDAO)Preconditions.checkNotNull((Object)applicationDAO);
        this.eventPublisher = (EventPublisher)Preconditions.checkNotNull((Object)eventPublisher);
        this.permissionManager = (PermissionManager)Preconditions.checkNotNull((Object)permissionManager);
        this.directoryInstanceLoader = (DirectoryInstanceLoader)Preconditions.checkNotNull((Object)directoryInstanceLoader);
        this.directorySynchroniser = (DirectorySynchroniser)Preconditions.checkNotNull((Object)directorySynchroniser);
        this.directoryPollerManager = (DirectoryPollerManager)Preconditions.checkNotNull((Object)directoryPollerManager);
        this.lockService = (ClusterLockService)Preconditions.checkNotNull((Object)lockService);
        this.synchronisationStatusManager = (SynchronisationStatusManager)Preconditions.checkNotNull((Object)synchronisationStatusManager);
        this.userPermissionDAO = (InternalUserPermissionDAO)Preconditions.checkNotNull((Object)userPermissionDAO);
    }

    public Directory addDirectory(Directory directory) throws DirectoryInstantiationException {
        if (!this.directoryInstanceLoader.canLoad(directory.getImplementationClass())) {
            throw new IllegalArgumentException("Failed to instantiate directory with class: " + directory.getImplementationClass());
        }
        Directory addedDirectory = this.directoryDao.add(directory);
        this.eventPublisher.publish((Object)new DirectoryCreatedEvent((Object)this, addedDirectory));
        return addedDirectory;
    }

    public Directory findDirectoryById(long directoryId) throws DirectoryNotFoundException {
        return this.directoryDao.findById(directoryId);
    }

    public List<Directory> findAllDirectories() {
        return this.directoryDao.findAll();
    }

    public List<Directory> searchDirectories(EntityQuery<Directory> query) {
        return this.directoryDao.search(query);
    }

    public Directory findDirectoryByName(String name) throws DirectoryNotFoundException {
        return this.directoryDao.findByName(name);
    }

    public Directory updateDirectory(Directory directory) throws DirectoryNotFoundException {
        if (directory.getId() == null) {
            throw new DirectoryNotFoundException(directory.getId());
        }
        this.findDirectoryById(directory.getId());
        Directory updatedDirectory = this.directoryDao.update(directory);
        this.eventPublisher.publish((Object)new DirectoryUpdatedEvent((Object)this, updatedDirectory));
        return updatedDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDirectory(Directory directory) throws DirectoryNotFoundException, DirectoryCurrentlySynchronisingException {
        ClusterLock lock = this.lockService.getLockForName(DirectorySynchronisationUtils.getLockName(directory.getId()));
        if (lock.tryLock()) {
            try {
                this.applicationDAO.removeDirectoryMappings(directory.getId().longValue());
                this.directoryDao.remove(directory);
                this.eventPublisher.publish((Object)new DirectoryDeletedEvent((Object)this, directory));
            }
            finally {
                lock.unlock();
            }
        } else {
            throw new DirectoryCurrentlySynchronisingException(directory.getId().longValue());
        }
    }

    public boolean supportsNestedGroups(long directoryId) throws DirectoryInstantiationException, DirectoryNotFoundException {
        RemoteDirectory remoteDirectory = this.getDirectoryImplementation(directoryId);
        return remoteDirectory.supportsNestedGroups();
    }

    public boolean isSynchronisable(long directoryId) throws DirectoryInstantiationException, DirectoryNotFoundException {
        RemoteDirectory remoteDirectory = this.getDirectoryImplementation(directoryId);
        return remoteDirectory instanceof SynchronisableDirectory;
    }

    public void synchroniseCache(long directoryId, SynchronisationMode mode) throws OperationFailedException, DirectoryNotFoundException {
        this.synchroniseCache(directoryId, mode, true);
    }

    public void synchroniseCache(long directoryId, SynchronisationMode mode, boolean runInBackground) throws OperationFailedException, DirectoryNotFoundException {
        RemoteDirectory remoteDirectory = this.getDirectoryImplementation(directoryId);
        if (remoteDirectory instanceof SynchronisableDirectory) {
            if (runInBackground) {
                this.directoryPollerManager.triggerPoll(directoryId, mode);
            } else {
                if (this.isSynchronising(directoryId)) {
                    throw new OperationFailedException("Directory " + directoryId + " is currently synchronising");
                }
                this.directorySynchroniser.synchronise((SynchronisableDirectory)remoteDirectory, mode);
            }
        }
    }

    public boolean isSynchronising(long directoryId) throws DirectoryInstantiationException, DirectoryNotFoundException {
        return this.directorySynchroniser.isSynchronising(directoryId);
    }

    public DirectorySynchronisationInformation getDirectorySynchronisationInformation(long directoryId) throws DirectoryInstantiationException, DirectoryNotFoundException {
        RemoteDirectory remoteDirectory = this.getDirectoryImplementation(directoryId);
        if (remoteDirectory instanceof SynchronisableDirectory) {
            return this.synchronisationStatusManager.getDirectorySynchronisationInformation(this.findDirectoryById(directoryId));
        }
        return null;
    }

    private RemoteDirectory getDirectoryImplementation(long directoryId) throws DirectoryInstantiationException, DirectoryNotFoundException {
        return this.directoryInstanceLoader.getDirectory(this.findDirectoryById(directoryId));
    }

    public com.atlassian.crowd.model.user.User authenticateUser(long directoryId, String username, PasswordCredential passwordCredential) throws OperationFailedException, InactiveAccountException, InvalidAuthenticationException, ExpiredCredentialException, DirectoryNotFoundException, UserNotFoundException {
        return this.getDirectoryImplementation(directoryId).authenticate(username, passwordCredential);
    }

    public com.atlassian.crowd.model.user.User findUserByName(long directoryId, String username) throws OperationFailedException, DirectoryNotFoundException, UserNotFoundException {
        return this.getDirectoryImplementation(directoryId).findUserByName(username);
    }

    public UserWithAttributes findUserWithAttributesByName(long directoryId, String username) throws OperationFailedException, DirectoryNotFoundException, UserNotFoundException {
        return this.getDirectoryImplementation(directoryId).findUserWithAttributesByName(username);
    }

    public <T> List<T> searchUsers(long directoryId, EntityQuery<T> query) throws OperationFailedException, DirectoryNotFoundException {
        return this.getDirectoryImplementation(directoryId).searchUsers(query);
    }

    public com.atlassian.crowd.model.user.User addUser(long directoryId, UserTemplate user, PasswordCredential credential) throws InvalidCredentialException, InvalidUserException, OperationFailedException, DirectoryPermissionException, DirectoryNotFoundException, UserAlreadyExistsException {
        if (this.userExists(directoryId, user.getName())) {
            throw new UserAlreadyExistsException(directoryId, user.getName());
        }
        if (IdentifierUtils.hasLeadingOrTrailingWhitespace((String)user.getName())) {
            throw new InvalidUserException((User)user, "User name may not contain leading or trailing whitespace");
        }
        Directory directory = this.findDirectoryById(directoryId);
        if (this.permissionManager.hasPermission(directory, OperationType.CREATE_USER)) {
            com.atlassian.crowd.model.user.User createdUser = this.getDirectoryImplementation(directoryId).addUser(user, credential);
            this.eventPublisher.publish((Object)new UserCreatedEvent((Object)this, directory, createdUser));
            return createdUser;
        }
        throw new DirectoryPermissionException("Directory does not allow adding of users");
    }

    private boolean userExists(long directoryId, String username) throws DirectoryNotFoundException, OperationFailedException {
        try {
            this.findUserByName(directoryId, username);
            return true;
        }
        catch (UserNotFoundException e) {
            return false;
        }
    }

    public com.atlassian.crowd.model.user.User updateUser(long directoryId, UserTemplate user) throws OperationFailedException, DirectoryPermissionException, InvalidUserException, DirectoryNotFoundException, UserNotFoundException {
        Directory directory = this.findDirectoryById(directoryId);
        if (this.permissionManager.hasPermission(directory, OperationType.UPDATE_USER)) {
            RemoteDirectory remoteDirectory = this.getDirectoryImplementation(directoryId);
            ImmutableUser currentUser = new ImmutableUser(remoteDirectory.findUserByName(user.getName()));
            com.atlassian.crowd.model.user.User updatedUser = remoteDirectory.updateUser(user);
            this.eventPublisher.publish((Object)new UserEditedEvent((Object)this, directory, updatedUser, (com.atlassian.crowd.model.user.User)currentUser));
            return updatedUser;
        }
        throw new DirectoryPermissionException("Directory does not allow user modifications");
    }

    public com.atlassian.crowd.model.user.User renameUser(long directoryId, String oldUsername, String newUsername) throws OperationFailedException, DirectoryPermissionException, InvalidUserException, DirectoryNotFoundException, UserNotFoundException, UserAlreadyExistsException {
        if (IdentifierUtils.hasLeadingOrTrailingWhitespace((String)newUsername)) {
            UserTemplate user = new UserTemplate(newUsername, directoryId);
            throw new InvalidUserException((User)user, "User name may not contain leading or trailing whitespace");
        }
        Directory directory = this.findDirectoryById(directoryId);
        if (this.permissionManager.hasPermission(directory, OperationType.UPDATE_USER)) {
            RemoteDirectory remoteDirectory = this.getDirectoryImplementation(directoryId);
            com.atlassian.crowd.model.user.User updatedUser = remoteDirectory.renameUser(oldUsername, newUsername);
            this.eventPublisher.publish((Object)new UserRenamedEvent((Object)this, directory, updatedUser, oldUsername));
            return updatedUser;
        }
        throw new DirectoryPermissionException("Directory does not allow user modifications");
    }

    public void storeUserAttributes(long directoryId, String username, Map<String, Set<String>> attributes) throws OperationFailedException, DirectoryPermissionException, DirectoryNotFoundException, UserNotFoundException {
        Directory directory = this.findDirectoryById(directoryId);
        if (!this.permissionManager.hasPermission(directory, OperationType.UPDATE_USER_ATTRIBUTE)) {
            throw new DirectoryPermissionException("Directory does not allow user attribute modifications");
        }
        this.getDirectoryImplementation(directoryId).storeUserAttributes(username, attributes);
        com.atlassian.crowd.model.user.User updatedUser = this.getDirectoryImplementation(directoryId).findUserByName(username);
        this.eventPublisher.publish((Object)new UserAttributeStoredEvent((Object)this, directory, updatedUser, attributes));
    }

    public void removeUserAttributes(long directoryId, String username, String attributeName) throws OperationFailedException, DirectoryPermissionException, DirectoryNotFoundException, UserNotFoundException {
        Directory directory = this.findDirectoryById(directoryId);
        if (!this.permissionManager.hasPermission(directory, OperationType.UPDATE_USER_ATTRIBUTE)) {
            throw new DirectoryPermissionException("Directory does not allow user attribute modifications");
        }
        this.getDirectoryImplementation(directoryId).removeUserAttributes(username, attributeName);
        com.atlassian.crowd.model.user.User updatedUser = this.getDirectoryImplementation(directoryId).findUserByName(username);
        this.eventPublisher.publish((Object)new UserAttributeDeletedEvent((Object)this, directory, updatedUser, attributeName));
    }

    public void updateUserCredential(long directoryId, String username, PasswordCredential credential) throws OperationFailedException, DirectoryPermissionException, InvalidCredentialException, DirectoryNotFoundException, UserNotFoundException {
        Directory directory = this.findDirectoryById(directoryId);
        if (this.permissionManager.hasPermission(directory, OperationType.UPDATE_USER)) {
            logger.info("The password for \"" + username + "\" in \"" + directory.getName() + "\" is being changed.");
            try {
                this.getDirectoryImplementation(directoryId).updateUserCredential(username, credential);
                this.eventPublisher.publish((Object)new UserCredentialUpdatedEvent((Object)this, directory, username, credential));
            }
            catch (InvalidCredentialException invalidCredentialException) {
                this.eventPublisher.publish((Object)new UserCredentialValidationFailed((Object)this, directory, invalidCredentialException.getViolatedConstraints()));
                throw invalidCredentialException;
            }
        } else {
            throw new DirectoryPermissionException("Directory does not allow user modifications");
        }
    }

    public void removeUser(long directoryId, String username) throws DirectoryPermissionException, OperationFailedException, DirectoryNotFoundException, UserNotFoundException {
        Directory directory = this.findDirectoryById(directoryId);
        if (!this.permissionManager.hasPermission(directory, OperationType.DELETE_USER)) {
            throw new DirectoryPermissionException("Directory does not allow user removal");
        }
        this.getDirectoryImplementation(directoryId).removeUser(username);
        this.eventPublisher.publish((Object)new UserDeletedEvent((Object)this, directory, username));
    }

    public Group findGroupByName(long directoryId, String groupName) throws OperationFailedException, GroupNotFoundException, DirectoryNotFoundException {
        return this.getDirectoryImplementation(directoryId).findGroupByName(groupName);
    }

    public GroupWithAttributes findGroupWithAttributesByName(long directoryId, String groupName) throws OperationFailedException, GroupNotFoundException, DirectoryNotFoundException {
        return this.getDirectoryImplementation(directoryId).findGroupWithAttributesByName(groupName);
    }

    public <T> List<T> searchGroups(long directoryId, EntityQuery<T> query) throws OperationFailedException, DirectoryNotFoundException {
        return this.getDirectoryImplementation(directoryId).searchGroups(query);
    }

    public Group addGroup(long directoryId, GroupTemplate group) throws InvalidGroupException, OperationFailedException, DirectoryPermissionException, DirectoryNotFoundException {
        Directory directory = this.findDirectoryById(directoryId);
        try {
            this.findGroupByName(directoryId, group.getName());
            throw new InvalidGroupException((Group)group, "Group with name <" + group.getName() + "> already exists in directory <" + directory.getName() + ">");
        }
        catch (GroupNotFoundException e) {
            if (IdentifierUtils.hasLeadingOrTrailingWhitespace((String)group.getName())) {
                throw new InvalidGroupException((Group)group, "Group name may not contain leading or trailing whitespace");
            }
            OperationType operationType = DirectoryManagerGeneric.getCreateOperationType((Group)group);
            if (!this.permissionManager.hasPermission(directory, operationType)) {
                if (operationType.equals((Object)OperationType.CREATE_GROUP)) {
                    throw new DirectoryPermissionException("Directory does not allow adding of groups");
                }
                throw new DirectoryPermissionException("Directory does not allow adding of roles");
            }
            Group createdGroup = this.getDirectoryImplementation(directoryId).addGroup(group);
            this.eventPublisher.publish((Object)new GroupCreatedEvent((Object)this, directory, createdGroup));
            return createdGroup;
        }
    }

    public Group updateGroup(long directoryId, GroupTemplate group) throws OperationFailedException, DirectoryPermissionException, InvalidGroupException, DirectoryNotFoundException, GroupNotFoundException, ReadOnlyGroupException {
        OperationType operationType;
        Directory directory = this.findDirectoryById(directoryId);
        if (!this.permissionManager.hasPermission(directory, operationType = DirectoryManagerGeneric.getUpdateOperationType((Group)group))) {
            if (operationType.equals((Object)OperationType.UPDATE_GROUP)) {
                throw new DirectoryPermissionException("Directory does not allow group modifications");
            }
            throw new DirectoryPermissionException("Directory does not allow role modifications");
        }
        Group updatedGroup = this.getDirectoryImplementation(directoryId).updateGroup(group);
        this.eventPublisher.publish((Object)new GroupUpdatedEvent((Object)this, directory, updatedGroup));
        return updatedGroup;
    }

    public Group renameGroup(long directoryId, String oldGroupname, String newGroupname) throws OperationFailedException, DirectoryPermissionException, InvalidGroupException, DirectoryNotFoundException, GroupNotFoundException {
        Group groupToUpdate;
        OperationType operationType;
        if (IdentifierUtils.hasLeadingOrTrailingWhitespace((String)newGroupname)) {
            GroupTemplate group = new GroupTemplate(newGroupname, directoryId);
            throw new InvalidGroupException((Group)group, "Group name may not contain leading or trailing whitespace");
        }
        Directory directory = this.findDirectoryById(directoryId);
        if (this.permissionManager.hasPermission(directory, operationType = DirectoryManagerGeneric.getUpdateOperationType(groupToUpdate = this.findGroupByName(directoryId, oldGroupname)))) {
            Group updatedGroup = this.getDirectoryImplementation(directoryId).renameGroup(oldGroupname, newGroupname);
            this.eventPublisher.publish((Object)new GroupUpdatedEvent((Object)this, directory, updatedGroup));
            return updatedGroup;
        }
        if (operationType.equals((Object)OperationType.UPDATE_GROUP)) {
            throw new DirectoryPermissionException("Directory does not allow group modifications");
        }
        throw new DirectoryPermissionException("Directory does not allow role modifications");
    }

    public void storeGroupAttributes(long directoryId, String groupName, Map<String, Set<String>> attributes) throws OperationFailedException, DirectoryPermissionException, DirectoryNotFoundException, GroupNotFoundException {
        Group groupToUpdate;
        OperationType operationType;
        Directory directory = this.findDirectoryById(directoryId);
        if (!this.permissionManager.hasPermission(directory, operationType = DirectoryManagerGeneric.getUpdateAttributeOperationType(groupToUpdate = this.findGroupByName(directoryId, groupName)))) {
            if (operationType.equals((Object)OperationType.UPDATE_GROUP)) {
                throw new DirectoryPermissionException("Directory does not allow group modifications");
            }
            throw new DirectoryPermissionException("Directory does not allow role modifications");
        }
        this.getDirectoryImplementation(directoryId).storeGroupAttributes(groupName, attributes);
        Group updateGroup = this.findGroupByName(directoryId, groupName);
        this.eventPublisher.publish((Object)new GroupAttributeStoredEvent((Object)this, directory, updateGroup, attributes));
    }

    public void removeGroupAttributes(long directoryId, String groupName, String attributeName) throws OperationFailedException, DirectoryPermissionException, DirectoryNotFoundException, GroupNotFoundException {
        Group groupToUpdate;
        OperationType operationType;
        Directory directory = this.findDirectoryById(directoryId);
        if (!this.permissionManager.hasPermission(directory, operationType = DirectoryManagerGeneric.getUpdateAttributeOperationType(groupToUpdate = this.findGroupByName(directoryId, groupName)))) {
            if (operationType.equals((Object)OperationType.UPDATE_GROUP_ATTRIBUTE)) {
                throw new DirectoryPermissionException("Directory does not allow group attribute modifications");
            }
            throw new DirectoryPermissionException("Directory does not allow role attribute modifications");
        }
        this.getDirectoryImplementation(directoryId).removeGroupAttributes(groupName, attributeName);
        Group updateGroup = this.findGroupByName(directoryId, groupName);
        this.eventPublisher.publish((Object)new GroupAttributeDeletedEvent((Object)this, directory, updateGroup, attributeName));
    }

    public void removeGroup(long directoryId, String groupName) throws DirectoryPermissionException, OperationFailedException, DirectoryNotFoundException, GroupNotFoundException, ReadOnlyGroupException {
        Group groupToDelete;
        OperationType operationType;
        Directory directory = this.findDirectoryById(directoryId);
        if (this.permissionManager.hasPermission(directory, operationType = DirectoryManagerGeneric.getDeleteOperationType(groupToDelete = this.findGroupByName(directoryId, groupName)))) {
            this.getDirectoryImplementation(directoryId).removeGroup(groupName);
            for (InternalGrantedPermission permission : this.userPermissionDAO.findAllPermissionsForGroup(groupName, directoryId)) {
                this.userPermissionDAO.revoke(permission);
            }
        } else {
            if (operationType.equals((Object)OperationType.DELETE_GROUP)) {
                throw new DirectoryPermissionException("Directory does not allow group removal");
            }
            throw new DirectoryPermissionException("Directory does not allow role removal");
        }
        this.applicationDAO.removeGroupMappings(directoryId, groupName);
        this.eventPublisher.publish((Object)new GroupDeletedEvent((Object)this, directory, groupName));
    }

    public boolean isUserDirectGroupMember(long directoryId, String username, String groupName) throws OperationFailedException, DirectoryNotFoundException {
        return this.getDirectoryImplementation(directoryId).isUserDirectGroupMember(username, groupName);
    }

    public boolean isGroupDirectGroupMember(long directoryId, String childGroup, String parentGroup) throws OperationFailedException, DirectoryNotFoundException {
        if (childGroup.equals(parentGroup)) {
            return false;
        }
        RemoteDirectory remoteDirectory = this.getDirectoryImplementation(directoryId);
        return remoteDirectory.supportsNestedGroups() && remoteDirectory.isGroupDirectGroupMember(childGroup, parentGroup);
    }

    public void addUserToGroup(long directoryId, String username, String groupName) throws DirectoryPermissionException, OperationFailedException, DirectoryNotFoundException, GroupNotFoundException, UserNotFoundException, ReadOnlyGroupException, MembershipAlreadyExistsException {
        Group groupToUpdate;
        OperationType operationType;
        Directory directory = this.findDirectoryById(directoryId);
        if (!this.permissionManager.hasPermission(directory, operationType = DirectoryManagerGeneric.getUpdateOperationType(groupToUpdate = this.findGroupByName(directoryId, groupName)))) {
            if (operationType.equals((Object)OperationType.UPDATE_GROUP)) {
                throw new DirectoryPermissionException("Directory does not allow group modifications");
            }
            throw new DirectoryPermissionException("Directory does not allow role modifications");
        }
        this.getDirectoryImplementation(directoryId).addUserToGroup(username, groupName);
        this.eventPublisher.publish((Object)new GroupMembershipCreatedEvent((Object)this, directory, username, groupName, MembershipType.GROUP_USER));
    }

    public void addGroupToGroup(long directoryId, String childGroup, String parentGroup) throws DirectoryPermissionException, OperationFailedException, InvalidMembershipException, NestedGroupsNotSupportedException, DirectoryNotFoundException, GroupNotFoundException, ReadOnlyGroupException, MembershipAlreadyExistsException {
        Group parentGroupToUpdate;
        OperationType operationType;
        RemoteDirectory remoteDirectory = this.getDirectoryImplementation(directoryId);
        if (!remoteDirectory.supportsNestedGroups()) {
            throw new NestedGroupsNotSupportedException(directoryId);
        }
        Directory directory = this.findDirectoryById(directoryId);
        if (this.permissionManager.hasPermission(directory, operationType = DirectoryManagerGeneric.getUpdateOperationType(parentGroupToUpdate = this.findGroupByName(directoryId, parentGroup)))) {
            if (childGroup.equals(parentGroup)) {
                throw new InvalidMembershipException("Cannot add direct circular group membership reference");
            }
        } else {
            if (operationType.equals((Object)OperationType.UPDATE_GROUP)) {
                throw new DirectoryPermissionException("Directory does not allow group modifications");
            }
            throw new DirectoryPermissionException("Directory does not allow role modifications");
        }
        remoteDirectory.addGroupToGroup(childGroup, parentGroup);
        this.eventPublisher.publish((Object)new GroupMembershipCreatedEvent((Object)this, directory, childGroup, parentGroup, MembershipType.GROUP_GROUP));
    }

    public void removeUserFromGroup(long directoryId, String username, String groupName) throws DirectoryPermissionException, OperationFailedException, MembershipNotFoundException, DirectoryNotFoundException, GroupNotFoundException, UserNotFoundException, ReadOnlyGroupException {
        Group groupToUpdate;
        OperationType operationType;
        Directory directory = this.findDirectoryById(directoryId);
        if (!this.permissionManager.hasPermission(directory, operationType = DirectoryManagerGeneric.getUpdateOperationType(groupToUpdate = this.findGroupByName(directoryId, groupName)))) {
            if (operationType.equals((Object)OperationType.UPDATE_GROUP)) {
                throw new DirectoryPermissionException("Directory does not allow group modifications");
            }
            throw new DirectoryPermissionException("Directory does not allow role modifications");
        }
        this.getDirectoryImplementation(directoryId).removeUserFromGroup(username, groupName);
        this.eventPublisher.publish((Object)new GroupMembershipDeletedEvent((Object)this, directory, username, groupName, MembershipType.GROUP_USER));
    }

    public void removeGroupFromGroup(long directoryId, String childGroup, String parentGroup) throws DirectoryPermissionException, OperationFailedException, InvalidMembershipException, MembershipNotFoundException, DirectoryNotFoundException, GroupNotFoundException, ReadOnlyGroupException {
        Group groupToUpdate;
        OperationType operationType;
        RemoteDirectory remoteDirectory = this.getDirectoryImplementation(directoryId);
        if (!remoteDirectory.supportsNestedGroups()) {
            throw new UnsupportedOperationException("Directory with id [" + directoryId + "] does not support nested groups");
        }
        Directory directory = this.findDirectoryById(directoryId);
        if (this.permissionManager.hasPermission(directory, operationType = DirectoryManagerGeneric.getUpdateOperationType(groupToUpdate = this.findGroupByName(directoryId, parentGroup)))) {
            if (childGroup.equals(parentGroup)) {
                throw new InvalidMembershipException("Cannot remove direct circular group membership reference");
            }
        } else {
            if (operationType.equals((Object)OperationType.UPDATE_GROUP)) {
                throw new DirectoryPermissionException("Directory does not allow group modifications");
            }
            throw new DirectoryPermissionException("Directory does not allow role modifications");
        }
        remoteDirectory.removeGroupFromGroup(childGroup, parentGroup);
        this.eventPublisher.publish((Object)new GroupMembershipDeletedEvent((Object)this, directory, childGroup, parentGroup, MembershipType.GROUP_GROUP));
    }

    public <T> List<T> searchDirectGroupRelationships(long directoryId, MembershipQuery<T> query) throws OperationFailedException, DirectoryNotFoundException {
        RemoteDirectory remoteDirectory = this.getDirectoryImplementation(directoryId);
        if (!remoteDirectory.supportsNestedGroups() && query.getEntityToMatch().getEntityType() == Entity.GROUP && query.getEntityToReturn().getEntityType() == Entity.GROUP) {
            return Collections.emptyList();
        }
        if (query.getEntityToMatch().getEntityType() == Entity.GROUP && query.getEntityToMatch().getGroupType() == GroupType.LEGACY_ROLE || query.getEntityToReturn().getEntityType() == Entity.GROUP && query.getEntityToReturn().getGroupType() == GroupType.LEGACY_ROLE) {
            return Collections.emptyList();
        }
        return this.getDirectoryImplementation(directoryId).searchGroupRelationships(query);
    }

    public BoundedCount countDirectMembersOfGroup(long directoryId, String groupName, int querySizeHint) throws OperationFailedException, DirectoryNotFoundException {
        return this.getDirectoryImplementation(directoryId).countDirectMembersOfGroup(groupName, querySizeHint);
    }

    public boolean isUserNestedGroupMember(long directoryId, String username, String groupName) throws OperationFailedException, DirectoryNotFoundException {
        if (this.getDirectoryImplementation(directoryId).supportsNestedGroups()) {
            return this.isUserNestedGroupMember(directoryId, username, groupName, new HashSet<String>());
        }
        return this.isUserDirectGroupMember(directoryId, username, groupName);
    }

    private boolean isUserNestedGroupMember(long directoryId, String username, String groupName, Set<String> visitedGroups) throws OperationFailedException, DirectoryNotFoundException {
        boolean isMember;
        block2: {
            Group childGroup;
            if (visitedGroups.contains(IdentifierUtils.toLowerCase((String)groupName))) {
                return false;
            }
            isMember = this.isUserDirectGroupMember(directoryId, username, groupName);
            visitedGroups.add(IdentifierUtils.toLowerCase((String)groupName));
            if (isMember) break block2;
            List subGroups = this.searchDirectGroupRelationships(directoryId, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(groupName).returningAtMost(-1));
            Iterator i$ = subGroups.iterator();
            while (i$.hasNext() && !(isMember = this.isUserNestedGroupMember(directoryId, username, (childGroup = (Group)i$.next()).getName(), visitedGroups))) {
            }
        }
        return isMember;
    }

    public boolean isGroupNestedGroupMember(long directoryId, String childGroup, String parentGroup) throws OperationFailedException, DirectoryNotFoundException {
        if (childGroup.equals(parentGroup)) {
            return false;
        }
        if (this.getDirectoryImplementation(directoryId).supportsNestedGroups()) {
            return this.isGroupNestedGroupMember(directoryId, childGroup, parentGroup, new HashSet<String>());
        }
        return this.isGroupDirectGroupMember(directoryId, childGroup, parentGroup);
    }

    private boolean isGroupNestedGroupMember(long directoryId, String childGroupName, String parentGroupName, Set<String> visitedGroups) throws OperationFailedException, DirectoryNotFoundException {
        boolean isMember;
        block2: {
            Group childGroup;
            if (visitedGroups.contains(IdentifierUtils.toLowerCase((String)parentGroupName))) {
                return false;
            }
            isMember = this.isGroupDirectGroupMember(directoryId, childGroupName, parentGroupName);
            visitedGroups.add(IdentifierUtils.toLowerCase((String)parentGroupName));
            if (isMember) break block2;
            List subGroups = this.searchDirectGroupRelationships(directoryId, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(parentGroupName).returningAtMost(-1));
            Iterator i$ = subGroups.iterator();
            while (i$.hasNext() && !(isMember = this.isGroupNestedGroupMember(directoryId, childGroupName, (childGroup = (Group)i$.next()).getName(), visitedGroups))) {
            }
        }
        return isMember;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> List<T> searchNestedGroupRelationships(long directoryId, MembershipQuery<T> query) throws OperationFailedException, DirectoryNotFoundException {
        List relations;
        if (!this.getDirectoryImplementation(directoryId).supportsNestedGroups()) return this.searchDirectGroupRelationships(directoryId, query);
        int totalResults = query.getStartIndex() + query.getMaxResults();
        if (query.getMaxResults() == -1) {
            totalResults = -1;
        }
        if (query.isFindChildren()) {
            if (query.getEntityToMatch().getEntityType() != Entity.GROUP) throw new IllegalArgumentException("You can only find the GROUP or USER members of a GROUP");
            if (query.getEntityToReturn().getEntityType() == Entity.USER) {
                relations = this.findNestedUserMembersOfGroup(directoryId, query.getEntityNameToMatch(), query.getEntityToMatch().getGroupType(), totalResults);
            } else {
                if (query.getEntityToReturn().getEntityType() != Entity.GROUP) throw new IllegalArgumentException("You can only find the GROUP or USER members of a GROUP");
                relations = this.findNestedGroupMembersOfGroup(directoryId, query.getEntityNameToMatch(), query.getEntityToMatch().getGroupType(), totalResults);
            }
        } else {
            if (query.getEntityToReturn().getEntityType() != Entity.GROUP) throw new IllegalArgumentException("You can only find the GROUP memberships of USER or GROUP");
            if (query.getEntityToMatch().getEntityType() == Entity.USER) {
                relations = this.findNestedGroupMembershipsOfUser(directoryId, query.getEntityNameToMatch(), query.getEntityToReturn().getGroupType(), totalResults);
            } else {
                if (query.getEntityToMatch().getEntityType() != Entity.GROUP) throw new IllegalArgumentException("You can only find the GROUP memberships of USER or GROUP");
                relations = this.findNestedGroupMembershipsOfGroup(directoryId, query.getEntityNameToMatch(), query.getEntityToReturn().getGroupType(), totalResults);
            }
        }
        relations = SearchResultsUtil.constrainResults(relations, (int)query.getStartIndex(), (int)query.getMaxResults());
        if (query.getReturnType() != String.class) return relations;
        return SearchResultsUtil.convertEntitiesToNames((Iterable)relations);
    }

    private List<Group> findNestedGroupMembershipsOfGroup(long directoryId, String groupName, GroupType groupType, int maxResults) throws OperationFailedException, DirectoryNotFoundException {
        Group group;
        try {
            group = this.findGroupByName(directoryId, groupName);
        }
        catch (GroupNotFoundException e) {
            return Collections.emptyList();
        }
        List<Group> nestedParents = this.findNestedGroupMembershipsIncludingGroups(directoryId, Arrays.asList(group), groupType, maxResults, false);
        return new ArrayList<Group>(nestedParents);
    }

    private List<Group> findNestedGroupMembershipsIncludingGroups(long directoryId, List<Group> groups, GroupType groupType, int maxResults, boolean includeOriginal) throws OperationFailedException, DirectoryNotFoundException {
        LinkedList<Object> groupsToVisit = new LinkedList<Object>();
        LinkedHashSet<Group> nestedParents = new LinkedHashSet<Group>();
        groupsToVisit.addAll(groups);
        int totalResults = maxResults;
        if (maxResults != -1 && !includeOriginal) {
            totalResults = maxResults + groups.size();
        }
        while (!(groupsToVisit.isEmpty() || totalResults != -1 && nestedParents.size() >= totalResults)) {
            Group groupToVisit = (Group)groupsToVisit.remove();
            if (nestedParents.contains(groupToVisit)) continue;
            nestedParents.add(groupToVisit);
            List directParents = this.searchDirectGroupRelationships(directoryId, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group((GroupType)groupType)).parentsOf(EntityDescriptor.group((GroupType)groupType)).withName(groupToVisit.getName()).returningAtMost(maxResults));
            groupsToVisit.addAll(directParents);
        }
        if (!includeOriginal) {
            nestedParents.removeAll(groups);
        }
        return new ArrayList<Group>(nestedParents);
    }

    private List<Group> findNestedGroupMembershipsOfUser(long directoryId, String username, GroupType groupType, int maxResults) throws OperationFailedException, DirectoryNotFoundException {
        List<Group> directGroupMemberships = this.searchDirectGroupRelationships(directoryId, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group((GroupType)groupType)).parentsOf(EntityDescriptor.user()).withName(username).returningAtMost(maxResults));
        return this.findNestedGroupMembershipsIncludingGroups(directoryId, directGroupMemberships, groupType, maxResults, true);
    }

    private List<Group> findNestedGroupMembersOfGroup(long directoryId, String groupName, GroupType groupType, int maxResults) throws OperationFailedException, DirectoryNotFoundException {
        Group group;
        try {
            group = this.findGroupByName(directoryId, groupName);
        }
        catch (GroupNotFoundException e) {
            return Collections.emptyList();
        }
        LinkedList<Object> groupsToVisit = new LinkedList<Object>();
        LinkedHashSet<Group> nestedMembers = new LinkedHashSet<Group>();
        groupsToVisit.add(group);
        while (!(groupsToVisit.isEmpty() || maxResults != -1 && nestedMembers.size() >= maxResults + 1)) {
            Group groupToVisit = (Group)groupsToVisit.remove();
            if (nestedMembers.contains(groupToVisit)) continue;
            nestedMembers.add(groupToVisit);
            List directMembers = this.searchDirectGroupRelationships(directoryId, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group((GroupType)groupType)).childrenOf(EntityDescriptor.group((GroupType)groupType)).withName(groupToVisit.getName()).returningAtMost(maxResults));
            groupsToVisit.addAll(directMembers);
        }
        nestedMembers.remove(group);
        return new ArrayList<Group>(nestedMembers);
    }

    private List<com.atlassian.crowd.model.user.User> findNestedUserMembersOfGroup(long directoryId, String groupName, GroupType groupType, int maxResults) throws OperationFailedException, DirectoryNotFoundException {
        Group group;
        try {
            group = this.findGroupByName(directoryId, groupName);
        }
        catch (GroupNotFoundException e) {
            return Collections.emptyList();
        }
        LinkedList<Object> groupsToVisit = new LinkedList<Object>();
        LinkedHashSet<Group> nestedGroupMembers = new LinkedHashSet<Group>();
        LinkedHashSet nestedUserMembers = new LinkedHashSet();
        groupsToVisit.add(group);
        while (!(groupsToVisit.isEmpty() || maxResults != -1 && nestedUserMembers.size() >= maxResults)) {
            Group groupToVisit = (Group)groupsToVisit.remove();
            List directUserMembers = this.searchDirectGroupRelationships(directoryId, QueryBuilder.queryFor(com.atlassian.crowd.model.user.User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group((GroupType)groupType)).withName(groupToVisit.getName()).returningAtMost(maxResults));
            nestedUserMembers.addAll(directUserMembers);
            if (nestedGroupMembers.contains(groupToVisit)) continue;
            nestedGroupMembers.add(groupToVisit);
            List directGroupMembers = this.searchDirectGroupRelationships(directoryId, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group((GroupType)groupType)).childrenOf(EntityDescriptor.group((GroupType)groupType)).withName(groupToVisit.getName()).returningAtMost(-1));
            groupsToVisit.addAll(directGroupMembers);
        }
        return new ArrayList<com.atlassian.crowd.model.user.User>(nestedUserMembers);
    }

    public BulkAddResult<com.atlassian.crowd.model.user.User> addAllUsers(long directoryId, Collection<UserTemplateWithCredentialAndAttributes> users, boolean overwrite) throws DirectoryPermissionException, OperationFailedException, DirectoryNotFoundException {
        List<UserTemplateWithCredentialAndAttributes> failedEntities;
        List<Object> successfulEntities;
        Directory directory = this.findDirectoryById(directoryId);
        if (!this.permissionManager.hasPermission(directory, OperationType.CREATE_USER)) {
            throw new DirectoryPermissionException("Directory does not allow adding of users");
        }
        BulkAddResult.Builder bulkAddResultBuilder = BulkAddResult.builder((long)users.size()).setOverwrite(overwrite);
        BulkRemoveResult<String> bulkRemoveExistingResult = this.removeAllUsers(directoryId, users, overwrite);
        ArrayList usersToAdd = overwrite ? Lists.newArrayList(DirectoryManagerGeneric.getDeletedAndNotFoundEntities(users, bulkRemoveExistingResult, NameComparator.normaliserOf(UserTemplateWithCredentialAndAttributes.class))) : Lists.newArrayList(DirectoryManagerGeneric.getNotFoundEntities(users, bulkRemoveExistingResult, NameComparator.normaliserOf(UserTemplateWithCredentialAndAttributes.class)));
        for (String stillExistingUserName : bulkRemoveExistingResult.getFailedEntities()) {
            try {
                bulkAddResultBuilder.addExistingEntity((Object)this.findUserByName(directoryId, stillExistingUserName));
                if (overwrite) {
                    logger.error("User could not be removed for bulk add with overwrite: {}", (Object)stillExistingUserName);
                    continue;
                }
                logger.info("User already exists in directory; overwrite is off so import will skip it: {}", (Object)stillExistingUserName);
            }
            catch (UserNotFoundException e) {
                logger.debug("User previously existed and couldn't be removed but is now missing so importing it: {}", (Object)stillExistingUserName);
                usersToAdd.add(Iterables.find(users, (Predicate)DirectoryEntityUtils.whereNameEquals((String)stillExistingUserName)));
            }
        }
        RemoteDirectory remoteDirectory = this.getDirectoryImplementation(directoryId);
        Set uniqueUsersToAdd = this.retainUniqueEntities(usersToAdd);
        if (remoteDirectory instanceof InternalRemoteDirectory) {
            BatchResult batchResult = ((InternalRemoteDirectory)remoteDirectory).addAllUsers(uniqueUsersToAdd);
            successfulEntities = batchResult.getSuccessfulEntities();
            failedEntities = batchResult.getFailedEntities();
        } else {
            successfulEntities = new ArrayList(uniqueUsersToAdd);
            failedEntities = new ArrayList();
            for (UserTemplateWithCredentialAndAttributes userTemplateWithCredentialAndAttributes : uniqueUsersToAdd) {
                try {
                    if (IdentifierUtils.hasLeadingOrTrailingWhitespace((String)userTemplateWithCredentialAndAttributes.getName())) {
                        throw new InvalidUserException((User)userTemplateWithCredentialAndAttributes, "User name may not contain leading or trailing whitespace");
                    }
                    successfulEntities.add(remoteDirectory.addUser((UserTemplate)userTemplateWithCredentialAndAttributes, userTemplateWithCredentialAndAttributes.getCredential()));
                }
                catch (Exception e) {
                    logger.error("Failed to add user: {}", (Object)userTemplateWithCredentialAndAttributes, (Object)e);
                    failedEntities.add(userTemplateWithCredentialAndAttributes);
                }
            }
        }
        bulkAddResultBuilder.addFailedEntities(failedEntities);
        DirectoryManagerGeneric.logFailedEntities(remoteDirectory, failedEntities);
        for (com.atlassian.crowd.model.user.User user : successfulEntities) {
            this.eventPublisher.publish((Object)new UserCreatedEvent((Object)this, directory, user));
        }
        return bulkAddResultBuilder.build();
    }

    private static <T extends DirectoryEntity> Collection<T> getDeletedAndNotFoundEntities(Collection<T> users, final BulkRemoveResult<String> bulkRemoveExistingResult, Function<T, String> normaliser) {
        return Collections2.filter(users, (Predicate)Predicates.compose((Predicate)new Predicate<String>(){

            public boolean apply(String normalisedUserName) {
                return !bulkRemoveExistingResult.getFailedEntities().contains(normalisedUserName) || bulkRemoveExistingResult.getMissingEntities().contains(normalisedUserName);
            }
        }, normaliser));
    }

    private static <T extends DirectoryEntity> Collection<T> getNotFoundEntities(Collection<T> users, final BulkRemoveResult<String> bulkRemoveExistingResult, final Function<T, String> normaliser) {
        return Collections2.filter(users, (Predicate)new Predicate<T>(){

            public boolean apply(T user) {
                return bulkRemoveExistingResult.getMissingEntities().contains(normaliser.apply(user));
            }
        });
    }

    private <T> Set<T> retainUniqueEntities(Collection<T> entities) {
        HashSet<T> uniqueEntities = new HashSet<T>(entities.size());
        for (T entity : entities) {
            boolean added;
            if (logger.isDebugEnabled()) {
                logger.debug("Going to add: " + entity);
            }
            if (added = uniqueEntities.add(entity)) continue;
            logger.warn("Duplicate entity. Entity is already in the set of entities to bulk add: " + entity);
        }
        return uniqueEntities;
    }

    /*
     * WARNING - void declaration
     */
    private BulkRemoveResult<String> removeAllUsers(long directoryId, Collection<? extends UserTemplate> users, boolean doRemove) throws DirectoryPermissionException, OperationFailedException, DirectoryNotFoundException {
        Directory directory = this.findDirectoryById(directoryId);
        if (!this.permissionManager.hasPermission(directory, OperationType.DELETE_USER) && doRemove) {
            throw new DirectoryPermissionException("Directory does not allow removing users");
        }
        RemoteDirectory remoteDirectory = this.getDirectoryImplementation(directoryId);
        ArrayList<UserTemplate> usersToRemove = new ArrayList<UserTemplate>();
        BulkRemoveResult.Builder resultBuilder = BulkRemoveResult.builder((long)users.size());
        Function usernameNormaliser = NameComparator.normaliserOf(com.atlassian.crowd.model.user.User.class);
        for (UserTemplate userTemplate : users) {
            try {
                this.findUserByName(directoryId, (String)usernameNormaliser.apply((Object)userTemplate));
                usersToRemove.add(userTemplate);
            }
            catch (UserNotFoundException e) {
                resultBuilder.addMissingEntity(usernameNormaliser.apply((Object)userTemplate));
            }
        }
        Set namesOfUniqueUsersToRemove = this.retainUniqueEntities(Collections2.transform(usersToRemove, (Function)usernameNormaliser));
        if (!doRemove) {
            resultBuilder.addFailedEntities(namesOfUniqueUsersToRemove);
        } else {
            void var11_13;
            ArrayList<String> failedEntities;
            if (remoteDirectory instanceof InternalRemoteDirectory) {
                BatchResult batchResult = ((InternalRemoteDirectory)remoteDirectory).removeAllUsers(namesOfUniqueUsersToRemove);
                List list = batchResult.getSuccessfulEntities();
                failedEntities = batchResult.getFailedEntities();
            } else {
                ArrayList<String> arrayList = new ArrayList<String>(namesOfUniqueUsersToRemove.size());
                failedEntities = new ArrayList();
                for (String username : namesOfUniqueUsersToRemove) {
                    try {
                        remoteDirectory.removeUser(username);
                        arrayList.add(username);
                    }
                    catch (Exception e) {
                        logger.error("Failed to remove user: {}", (Object)username, (Object)e);
                        failedEntities.add(username);
                    }
                }
            }
            resultBuilder.addFailedEntities(failedEntities);
            DirectoryManagerGeneric.logFailedEntitiesWithNames(remoteDirectory, failedEntities);
            for (String deletedUser : var11_13) {
                this.eventPublisher.publish((Object)new UserDeletedEvent((Object)this, directory, deletedUser));
            }
        }
        return resultBuilder.build();
    }

    public BulkAddResult<Group> addAllGroups(long directoryId, Collection<GroupTemplate> groups, boolean overwrite) throws DirectoryPermissionException, OperationFailedException, DirectoryNotFoundException {
        List<GroupTemplate> failedEntities;
        List<Group> successfulEntities;
        Directory directory = this.findDirectoryById(directoryId);
        if (!this.permissionManager.hasPermission(directory, OperationType.CREATE_GROUP)) {
            throw new DirectoryPermissionException("Directory does not allow adding of groups");
        }
        BulkAddResult.Builder bulkAddResultBuilder = BulkAddResult.builder((long)groups.size()).setOverwrite(overwrite);
        BulkRemoveResult<String> bulkRemoveExistingResult = this.removeAllGroups(directoryId, groups, overwrite);
        ArrayList groupsToAdd = overwrite ? Lists.newArrayList(DirectoryManagerGeneric.getDeletedAndNotFoundEntities(groups, bulkRemoveExistingResult, NameComparator.normaliserOf(GroupTemplate.class))) : Lists.newArrayList(DirectoryManagerGeneric.getNotFoundEntities(groups, bulkRemoveExistingResult, NameComparator.normaliserOf(GroupTemplate.class)));
        for (String stillExistingGroupName : bulkRemoveExistingResult.getFailedEntities()) {
            try {
                bulkAddResultBuilder.addExistingEntity((Object)this.findGroupByName(directoryId, stillExistingGroupName));
                if (overwrite) {
                    logger.error("Group could not be removed for bulk add with overwrite: {}", (Object)stillExistingGroupName);
                    continue;
                }
                logger.info("Group already exists in directory; overwrite is off so import will skip it: {}", (Object)stillExistingGroupName);
            }
            catch (GroupNotFoundException e) {
                logger.debug("Group previously existed and couldn't be removed but is now missing so importing it: {}", (Object)stillExistingGroupName);
                groupsToAdd.add(Iterables.find(groups, (Predicate)DirectoryEntityUtils.whereNameEquals((String)stillExistingGroupName)));
            }
        }
        RemoteDirectory remoteDirectory = this.getDirectoryImplementation(directoryId);
        Set uniqueGroupsToAdd = this.retainUniqueEntities(groupsToAdd);
        if (remoteDirectory instanceof InternalRemoteDirectory) {
            BatchResult batchResult = ((InternalRemoteDirectory)remoteDirectory).addAllGroups(uniqueGroupsToAdd);
            successfulEntities = batchResult.getSuccessfulEntities();
            failedEntities = batchResult.getFailedEntities();
        } else {
            successfulEntities = new ArrayList(uniqueGroupsToAdd.size());
            failedEntities = new ArrayList();
            for (GroupTemplate group : uniqueGroupsToAdd) {
                try {
                    if (IdentifierUtils.hasLeadingOrTrailingWhitespace((String)group.getName())) {
                        throw new InvalidGroupException((Group)group, "Group name may not contain leading or trailing whitespace");
                    }
                    successfulEntities.add(remoteDirectory.addGroup(group));
                }
                catch (Exception e) {
                    logger.error("Failed to add group: {}", (Object)group, (Object)e);
                    failedEntities.add(group);
                }
            }
        }
        bulkAddResultBuilder.addFailedEntities(failedEntities);
        DirectoryManagerGeneric.logFailedEntities(remoteDirectory, failedEntities);
        for (Group addedGroup : successfulEntities) {
            this.eventPublisher.publish((Object)new GroupCreatedEvent((Object)this, directory, addedGroup));
        }
        return bulkAddResultBuilder.build();
    }

    private BulkRemoveResult<String> removeAllGroups(long directoryId, Collection<GroupTemplate> groups, boolean doRemove) throws DirectoryPermissionException, OperationFailedException, DirectoryNotFoundException {
        Directory directory = this.findDirectoryById(directoryId);
        if (!this.permissionManager.hasPermission(directory, OperationType.DELETE_GROUP) && doRemove) {
            throw new DirectoryPermissionException("Directory does not allow removing groups");
        }
        RemoteDirectory remoteDirectory = this.getDirectoryImplementation(directoryId);
        ArrayList<GroupTemplate> groupsToRemove = new ArrayList<GroupTemplate>();
        BulkRemoveResult.Builder resultBuilder = BulkRemoveResult.builder((long)groups.size());
        Function groupNameNormaliser = NameComparator.normaliserOf(Group.class);
        for (GroupTemplate group : groups) {
            try {
                this.findGroupByName(directoryId, (String)groupNameNormaliser.apply((Object)group));
                groupsToRemove.add(group);
            }
            catch (GroupNotFoundException e) {
                resultBuilder.addMissingEntity(groupNameNormaliser.apply((Object)group));
            }
        }
        Set namesOfUniqueGroupsToRemove = this.retainUniqueEntities(Collections2.transform(groupsToRemove, (Function)groupNameNormaliser));
        if (!doRemove) {
            resultBuilder.addFailedEntities(namesOfUniqueGroupsToRemove);
        } else {
            ArrayList<String> failedEntities;
            List<String> successfulEntities;
            if (remoteDirectory instanceof InternalRemoteDirectory) {
                BatchResult batchResult = ((InternalRemoteDirectory)remoteDirectory).removeAllGroups(namesOfUniqueGroupsToRemove);
                successfulEntities = batchResult.getSuccessfulEntities();
                failedEntities = batchResult.getFailedEntities();
            } else {
                successfulEntities = new ArrayList(namesOfUniqueGroupsToRemove.size());
                failedEntities = new ArrayList();
                for (String groupName : namesOfUniqueGroupsToRemove) {
                    try {
                        remoteDirectory.removeGroup(groupName);
                        successfulEntities.add(groupName);
                    }
                    catch (Exception e) {
                        logger.error("Failed to remove group: {}", (Object)groupName, (Object)e);
                        failedEntities.add(groupName);
                    }
                }
            }
            resultBuilder.addFailedEntities(failedEntities);
            DirectoryManagerGeneric.logFailedEntitiesWithNames(remoteDirectory, failedEntities);
            for (String deletedGroup : successfulEntities) {
                this.eventPublisher.publish((Object)new GroupDeletedEvent((Object)this, directory, deletedGroup));
            }
        }
        return resultBuilder.build();
    }

    public BulkAddResult<String> addAllUsersToGroup(long directoryId, Collection<String> userNames, String groupName) throws DirectoryPermissionException, OperationFailedException, DirectoryNotFoundException, GroupNotFoundException {
        Group groupToUpdate;
        OperationType operationType;
        Directory directory = this.findDirectoryById(directoryId);
        if (this.permissionManager.hasPermission(directory, operationType = DirectoryManagerGeneric.getUpdateOperationType(groupToUpdate = this.findGroupByName(directoryId, groupName)))) {
            List<String> successfulUsers;
            RemoteDirectory remoteDirectory = this.directoryInstanceLoader.getDirectory(directory);
            Set<String> usersToAdd = this.retainUniqueEntities(userNames);
            BulkAddResult.Builder resultBuilder = BulkAddResult.builder((long)userNames.size()).setOverwrite(true);
            if (remoteDirectory instanceof InternalRemoteDirectory) {
                BatchResult batchResult = ((InternalRemoteDirectory)remoteDirectory).addAllUsersToGroup(usersToAdd, groupName);
                successfulUsers = batchResult.getSuccessfulEntities();
                for (String username : batchResult.getFailedEntities()) {
                    if (this.isUserDirectGroupMember(directoryId, username, groupName)) {
                        resultBuilder.addExistingEntity((Object)username);
                        continue;
                    }
                    resultBuilder.addFailedEntity((Object)username);
                }
            } else {
                successfulUsers = new ArrayList(usersToAdd.size());
                for (String username : usersToAdd) {
                    try {
                        this.addUserToGroup(directoryId, username, groupName);
                        successfulUsers.add(username);
                    }
                    catch (MembershipAlreadyExistsException e) {
                        resultBuilder.addExistingEntity((Object)username);
                    }
                    catch (Exception e) {
                        resultBuilder.addFailedEntity((Object)username);
                        logger.error(e.getMessage());
                    }
                }
            }
            for (String username : successfulUsers) {
                this.eventPublisher.publish((Object)new GroupMembershipCreatedEvent((Object)this, directory, username, groupName, MembershipType.GROUP_USER));
            }
            BulkAddResult bulkAddResult = resultBuilder.build();
            for (String failedUser : bulkAddResult.getFailedEntities()) {
                logger.warn("Could not add the following user to the group [ {} ]: {}", (Object)groupName, (Object)failedUser);
            }
            return bulkAddResult;
        }
        if (operationType.equals((Object)OperationType.UPDATE_GROUP)) {
            throw new DirectoryPermissionException("Directory does not allow group modifications");
        }
        throw new DirectoryPermissionException("Directory does not allow role modifications");
    }

    private static OperationType getCreateOperationType(Group group) {
        switch (group.getType()) {
            case GROUP: {
                return OperationType.CREATE_GROUP;
            }
        }
        throw new UnsupportedOperationException();
    }

    private static OperationType getUpdateOperationType(Group group) {
        switch (group.getType()) {
            case GROUP: {
                return OperationType.UPDATE_GROUP;
            }
        }
        throw new UnsupportedOperationException();
    }

    private static OperationType getUpdateAttributeOperationType(Group group) {
        switch (group.getType()) {
            case GROUP: {
                return OperationType.UPDATE_GROUP_ATTRIBUTE;
            }
        }
        throw new UnsupportedOperationException();
    }

    private static OperationType getDeleteOperationType(Group group) {
        switch (group.getType()) {
            case GROUP: {
                return OperationType.DELETE_GROUP;
            }
        }
        throw new UnsupportedOperationException();
    }

    private static void logFailedEntities(RemoteDirectory remoteDirectory, Collection<? extends DirectoryEntity> failedEntities) {
        DirectoryManagerGeneric.logFailedEntitiesWithNames(remoteDirectory, Iterables.transform(failedEntities, (Function)new Function<DirectoryEntity, String>(){

            public String apply(DirectoryEntity input) {
                return input.getName();
            }
        }));
    }

    private static void logFailedEntitiesWithNames(RemoteDirectory remoteDirectory, Iterable<String> failedEntities) {
        String directoryName = remoteDirectory.getDescriptiveName();
        for (String failedEntity : failedEntities) {
            logger.warn("Could not add the following entityName to the directory [ {} ]: {}", (Object)directoryName, (Object)failedEntity);
        }
    }

    public com.atlassian.crowd.model.user.User findUserByExternalId(long directoryId, String externalId) throws DirectoryNotFoundException, UserNotFoundException, OperationFailedException {
        return this.getDirectoryImplementation(directoryId).findUserByExternalId(externalId);
    }

    public UserWithAttributes findUserWithAttributesByExternalId(long directoryId, String externalId) throws DirectoryNotFoundException, UserNotFoundException, OperationFailedException {
        RemoteDirectory directory = this.getDirectoryImplementation(directoryId);
        com.atlassian.crowd.model.user.User user = directory.findUserByExternalId(externalId);
        return directory.findUserWithAttributesByName(user.getName());
    }

    public void expireAllPasswords(long directoryId) throws OperationFailedException, DirectoryNotFoundException {
        RemoteDirectory remoteDirectory = this.getDirectoryImplementation(directoryId);
        if (!remoteDirectory.supportsPasswordExpiration()) {
            throw new OperationFailedException("Expiring passwords not supported by directory " + directoryId);
        }
        remoteDirectory.expireAllPasswords();
    }

    public boolean supportsExpireAllPasswords(long directoryId) throws DirectoryInstantiationException, DirectoryNotFoundException {
        RemoteDirectory remoteDirectory = this.getDirectoryImplementation(directoryId);
        return remoteDirectory.supportsPasswordExpiration();
    }
}

