/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.loader;

import com.atlassian.crowd.cql.parser.CqlQueryParser;
import com.atlassian.crowd.directory.CachingDirectory;
import com.atlassian.crowd.directory.DbCachingRemoteDirectory;
import com.atlassian.crowd.directory.InternalRemoteDirectory;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.ldap.cache.DirectoryCacheFactory;
import com.atlassian.crowd.directory.loader.CachingDirectoryInstanceLoader;
import com.atlassian.crowd.directory.loader.DelegatingDirectoryInstanceLoader;
import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.directory.loader.InternalDirectoryInstanceLoader;
import com.atlassian.crowd.directory.loader.InternalHybridDirectoryInstanceLoader;
import com.atlassian.crowd.directory.loader.LDAPDirectoryInstanceLoader;
import com.atlassian.crowd.directory.loader.RemoteCrowdDirectoryInstanceLoader;
import com.atlassian.crowd.directory.monitor.DirectoryMonitorCreationException;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.manager.directory.monitor.DirectoryMonitorAlreadyRegisteredException;
import com.atlassian.crowd.manager.directory.monitor.DirectoryMonitorManager;
import com.atlassian.crowd.manager.directory.monitor.DirectoryMonitorRegistrationException;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.event.api.EventPublisher;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbCachingRemoteDirectoryInstanceLoaderImpl
extends CachingDirectoryInstanceLoader
implements InternalHybridDirectoryInstanceLoader {
    private static final Logger log = LoggerFactory.getLogger(DbCachingRemoteDirectoryInstanceLoaderImpl.class);
    private final InternalDirectoryInstanceLoader internalDirectoryInstanceLoader;
    private final DirectoryMonitorManager directoryMonitorManager;
    private final DirectoryInstanceLoader remoteDirectoryInstanceLoader;
    private final DirectoryCacheFactory directoryCacheFactory;
    private final CqlQueryParser cqlQueryParser;

    public DbCachingRemoteDirectoryInstanceLoaderImpl(DirectoryInstanceLoader remoteDirectoryInstanceLoader, InternalDirectoryInstanceLoader internalDirectoryInstanceLoader, DirectoryMonitorManager directoryMonitorManager, DirectoryCacheFactory directoryCacheFactory, EventPublisher eventPublisher, CqlQueryParser cqlQueryParser) {
        super(eventPublisher);
        this.remoteDirectoryInstanceLoader = remoteDirectoryInstanceLoader;
        this.internalDirectoryInstanceLoader = internalDirectoryInstanceLoader;
        this.directoryMonitorManager = directoryMonitorManager;
        this.directoryCacheFactory = directoryCacheFactory;
        this.cqlQueryParser = cqlQueryParser;
    }

    public DbCachingRemoteDirectoryInstanceLoaderImpl(LDAPDirectoryInstanceLoader ldapDirectoryInstanceLoader, RemoteCrowdDirectoryInstanceLoader remoteCrowdDirectoryInstanceLoader, InternalDirectoryInstanceLoader internalDirectoryInstanceLoader, DirectoryMonitorManager directoryMonitorManager, DirectoryCacheFactory directoryCacheFactory, EventPublisher eventPublisher, CqlQueryParser cqlQueryParser) {
        this(DbCachingRemoteDirectoryInstanceLoaderImpl.makeDelegatingInstanceLoader(Arrays.asList(ldapDirectoryInstanceLoader, remoteCrowdDirectoryInstanceLoader)), internalDirectoryInstanceLoader, directoryMonitorManager, directoryCacheFactory, eventPublisher, cqlQueryParser);
    }

    private static DirectoryInstanceLoader makeDelegatingInstanceLoader(List<DirectoryInstanceLoader> delegateLoaders) {
        DelegatingDirectoryInstanceLoader directoryInstanceLoader = new DelegatingDirectoryInstanceLoader(delegateLoaders);
        return directoryInstanceLoader;
    }

    protected RemoteDirectory getNewDirectory(Directory directory) throws DirectoryInstantiationException {
        RemoteDirectory remoteDirectory = this.getRawDirectory(directory.getId(), directory.getImplementationClass(), directory.getAttributes());
        InternalRemoteDirectory internalDirectory = this.getRawInternalDirectory(directory);
        DbCachingRemoteDirectory dbCachingRemoteDirectory = new DbCachingRemoteDirectory(remoteDirectory, internalDirectory, this.directoryCacheFactory, this.cqlQueryParser);
        try {
            if (directory.isActive()) {
                Long id = directory.getId();
                if (id == null) {
                    log.error("Could not add a monitor for unsaved directory with name '{}'", (Object)directory.getName());
                } else if (!this.directoryMonitorManager.hasMonitor(id.longValue())) {
                    this.directoryMonitorManager.addMonitor((RemoteDirectory)dbCachingRemoteDirectory);
                }
            }
        }
        catch (DirectoryMonitorAlreadyRegisteredException e) {
        }
        catch (DirectoryMonitorCreationException e) {
            log.error("Could not add a monitor for the directory with id: {}", (Object)directory.getId(), (Object)e);
        }
        catch (DirectoryMonitorRegistrationException e) {
            log.error("Could not add a monitor for the directory with id: {}", (Object)directory.getId(), (Object)e);
        }
        return dbCachingRemoteDirectory;
    }

    private InternalRemoteDirectory getRawInternalDirectory(Directory directory) throws DirectoryInstantiationException {
        DirectoryImpl internal = new DirectoryImpl(directory);
        HashMap<String, String> newAttributes = new HashMap<String, String>(internal.getAttributes());
        newAttributes.put("user_encryption_method", "atlassian-security");
        internal.setAttributes(newAttributes);
        return this.internalDirectoryInstanceLoader.getRawDirectory(directory.getId(), CachingDirectory.class.getName(), newAttributes);
    }

    public RemoteDirectory getRawDirectory(Long id, String className, Map<String, String> attributes) throws DirectoryInstantiationException {
        return this.remoteDirectoryInstanceLoader.getRawDirectory(id, className, attributes);
    }

    public boolean canLoad(String className) {
        return this.remoteDirectoryInstanceLoader.canLoad(className);
    }
}

